/*!
 * @file qt_gui_datadir_fallback.h
 * @brief Definition of ...
*/

#ifndef __QT_GUI_DATADIR_FALLBACK_H
#define __QT_GUI_DATADIR_FALLBACK_H

#include "../gui.h"
#include "../gui_element.h"
#include <QtGui/QApplication>
#include <QtGui/QMainWindow>

namespace OrxGui
{
  class QtGuiDataDirFallback : public QApplication, public OrxGui::Gui
  {
    Q_OBJECT
    public:
      QtGuiDataDirFallback(int argc, char** argv);
      virtual ~QtGuiDataDirFallback();

    //! Start the Gui
      virtual void startGui();
    //! Stop the gui
      virtual void stopGui();
    //! Suspend the Gui.
      virtual void suspend();
    //! Update the Gui.
      virtual void update();

    public slots:
      void quitApp();
      void startApp();

    private:
      QMainWindow*              mainWindow;
      std::list<Element*>       elements;       //!< A List of Elements within the QTGui
  };
}

#endif /* __QT_GUI_DATADIR_FALLBACK_H */
