/*!
 * @file md3_bone_frame.h
 *
 * Code heavely inspired by: JAVA MD3 Model Viewer - A Java based Quake 3 model viewer
 * Copyright (C) 1999 Erwin 'KLR8' Vervaet
 */

#ifndef _MD3_BONE_FRAME_ANIMATION_H
#define _MD3_BONE_FRAME_ANIMATION_H

#include "vector.h"

#include <string>

namespace md3
{

typedef struct MD3BoneFrameData {
  sVec3D  mins;
  sVec3D  maxs;
  sVec3D  position;
  float   scale;
  char    creator[16];
};


class MD3Tag;

class MD3BoneFrame
{
  public:
    /** create a MD3BoneFrame object with the data coming from the specified input stream */
    MD3BoneFrame(int tagNum /*, DataInput din*/);
    MD3BoneFrame(/*int tagNum*/);
    virtual ~MD3BoneFrame();


  public:
    Vector              mins;              //!< lower extrema of the bounding box of this bone anumation frame
    Vector              maxs;              //!< upper extrema of the bounding box of this bone anumation frame
    Vector              position;          //!< coordinate origin within the bounding box

    std::string         cratorName;        //!< the name of the creator
    float               scale;             //!< scale of the box

    MD3Tag**            tags;              //!< arrays of tags size

    MD3BoneFrameData*   data;              //!< reference md3 bone frames data
};

}

#endif /* _MD3_BONE_FRAME_ANIMATION_H */
