/*!
 * @file cr_object_damage.h
 *  Definition of a collision reaction: dealing damage to an object
 */

#ifndef _CR_PHYSICS_GROUND_WALK_H
#define _CR_PHYSICS_GROUND_WALK_H

#include "collision_reaction.h"


class Collision;

//! A class representing a reaction to a collision: dealing damage to an object
class CRPhysicsGroundWalk : public CollisionReaction
{
  public:
    CRPhysicsGroundWalk();
    virtual ~CRPhysicsGroundWalk();

    virtual void reactToCollision(Collision* collision);

    virtual void update(WorldEntity* entity);

  private:
    Vector       lastPosition;                //!< vector with the last valid position
    Vector       afterLastPosition;           //!< vector for the after last
    Quaternion   lastDirection;               //!< quat with the last valid direction

    Vector       lastPositions[10];           //!< last 10 positions
    float        downspeed;
};

#endif /* _CR_PHYSICS_GROUND_WALK_H */
