/*
   orxonox - the future of 3D-vertical-scrollers
 
   Copyright (C) 2004 orx
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION_REACTION

#include "collision.h"
#include "collision_event.h"

#include "physics_interface.h"

#include "world_entity.h"
#include "cr_physics_ground_walk.h"

#include <vector>

using namespace std;


/**
 *  standard constructor
 */
CRPhysicsGroundWalk::CRPhysicsGroundWalk ()
    : CollisionReaction()
{
  this->setClassID(CL_CR_PHYSICS_GROUND_WALK, "CRPhysicsGroundWalk");
}


/**
 *  standard deconstructor
 */
CRPhysicsGroundWalk::~CRPhysicsGroundWalk ()
{}


/**
 * caluculates and applys the reaction to a specific collision
 *  @param collision the collision
 */
void CRPhysicsGroundWalk::reactToCollision(Collision* collision)
{
  CollisionEvent* ce = collision->getCollisionEvents().front();
  Vector normal = ce->getGroundNormal();
  // normal.normalize();

  // put it back
  //   PRINTF(0)("putting it back to lastPos: \n");
  //   this->lastPositions[0].debug();
  //   PRINTF(0)("current pos:\n");
  //   collision->getEntityB()->getAbsCoor().debug();


  Vector height = ce->getCollisionPosition() - collision->getEntityB()->getAbsCoor();

  if(ce->getCollisionPosition().x <= 0.9 && ce->getGroundNormal().len() <= 1.4f) {
    collision->getEntityB()->setAbsCoor(collision->getEntityB()->getLastAbsCoor());
    return;
  }
  if(ce->getGroundNormal().len() <= 0.1f) {
    collision->getEntityB()->setAbsCoor(collision->getEntityB()->getLastAbsCoor());
    return;
  }
  if(ce->getGroundNormal().len() >= 1.4f) {
    downspeed++;
    collision->getEntityB()->setAbsCoor(collision->getEntityB()->getAbsCoor() + Vector(0.0,-0.08*downspeed,0.0));
    return;
  }


  if(height.y < -3.510001 + 10.0) // Above ground
  {
    if(height.y > -15.6) // Snap in
    {
      downspeed = 0;
      collision->getEntityB()->setAbsCoor(collision->getEntityB()->getAbsCoor() + Vector(0.0,height.y+3.500005 + 10.0,0.0));
    } else
    {
      downspeed++;
      collision->getEntityB()->setAbsCoor(collision->getEntityB()->getAbsCoor() + Vector(0.0,-0.08*downspeed,0.0));
    }

  }
  else {
    if(height.y > -3.50000 + 10.0  && height.y <    9.9+ 10.0) // below ground
    {
      //if(downspeed <= 0) downspeed =1;
      collision->getEntityB()->setAbsCoor(collision->getEntityB()->getAbsCoor() + Vector(0.0, 0.00001 /*height.y+3.500005 + 10.0*/,0.0));
      //collision->getEntityB()->setVelocity(Vector(0.0,0.0,0.0));
      downspeed = 0;
    }

  }


  /*
  PRINTF(0)("Collision with Ground: \n");
  collision->getEntityB()->getAbsCoor().debug();
  collision->getEntityB()->setVelocity(Vector());
  collision->getEntityB()->setAbsCoor(this->lastPositions[1]);

  */
}




/**
 * use this to do some collision offline calculations, only called for bContinuousPoll == true
 */
void CRPhysicsGroundWalk::update(WorldEntity* owner)
{
  for( int i = 9; i > 0; i--) {
    this->lastPositions[i] = this->lastPositions[i-1];
    //     PRINTF(0)("lastPosition[%i]: %f, %f, %f\n", i, lastPositions[i].x, lastPositions[i].y, lastPositions[i].z);
  }
  this->lastPositions[0] = owner->getAbsCoor();
}


