/*!
 * @file aabb.h
  *  Definition of an AABB (Axix Aligned Bounding Box)

*/

#ifndef _AABB_H
#define _AABB_H

#include "base_object.h"
#include "bounding_volume.h"

template<class T> class tList;

//! A class representing an extended bounding volume tree: an obb tree
class AABB : public BoundingVolume {

 public:
  AABB();
  virtual ~AABB();


  inline Vector getAxisX () const { return this->axis[0]; }
  inline Vector getAxisY () const { return this->axis[1]; }
  inline Vector getAxisZ () const { return this->axis[2]; }

  inline const float* getHalfLength() const { return this->halfLength; }

  virtual void mergeWith(const BoundingVolume &bv);

  virtual void drawBV(int currentDepth, int drawMode) const;



 public:
  Vector           axis[3];                    //!< Axes of oriented box [x,y,z]
  float            halfLength[3];              //!< Half lengths of the box along the axis
  float            covarianceMatrix[3][3];     //!< the covariance matrix

  bool             bCollided;                  //!< is true if this obb has collided

};

#endif /* _AABB_H */
