/*!
 * @file md3_mesh.h
 *
 * Code heavely inspired by: JAVA MD3 Model Viewer - A Java based Quake 3 model viewer
 * Copyright (C) 1999 Erwin 'KLR8' Vervaet
 */

#ifndef _MD3_MESH_H
#define _MD3_MESH_H


#include <string>

#include "md_model_structure.h"

#include "vector.h"

class Material;


namespace md3
{

  typedef struct MD3MeshHeader {

    int     id;                             //!< individual id, must be IDP3
    char    name[68];                       //!< the name of the mesh

    int     meshFrameNum;                   //!< numbers of frames
    int     textureNum;                     //!< numbers of textures
    int     vertexNum;                      //!< numbers of verteces
    int     triangleNum;                    //!< number of triangles

    int     triangleStart;                  //!< triangle start offset
    int     textureStart;                   //!< texture start offset
    int     texVecStart;                    //!< tex vec start offset
    int     vertexStart;                    //!< vertex start offset

    int     meshSize;                       //!< total mesh size
  };


  typedef struct MD3Triangle  {
    int     vertexOffset[3];                //!< the vertex offsets of the triangles in the vertex array
  };

  typedef struct MD3Texture {
    char    fileName[68];                   //!< the filename of the texture. path relativly to the model file
  };

  typedef struct MD3TexVecs {
    float   textureCoord[2];                //!< the texture u/v coordinates
  };

  typedef struct MD3Normal {
    int     vertexNormal[2];                //!< vertex normals
  };

  typedef struct MD3VertexCompressed {
    short   vector[3];                      //!< compressed vertex information
    unsigned char vertexNormal[2];          //!< vertex normals compressed
  };



class MD3Mesh
{
  public:
    MD3Mesh();
    virtual ~MD3Mesh();


  public:
    MD3MeshHeader*     header;                  //!< the header of the mesh

    Material*          material;                //!< the material/textures of the models
    MD3Triangle*       triangles;               //!< indices into mesh frames and texture coord arrays
    MD3TexVecs*        texVecs;                 //!< tex vecs coordinates
    sVec3D**           meshFrames;              //!< mesh frames
    MD3Normal**        normals;                 //!< 3d array of normals with spherical coordinates giving the dir of the vertex normal

};

}

#endif /* _MD3_MESH_H */
