/*!
 * @file md3_animation.h
 *
 * Code heavely inspired by: JAVA MD3 Model Viewer - A Java based Quake 3 model viewer
 * Copyright (C) 1999 Erwin 'KLR8' Vervaet
 */

#ifndef _MD3_ANIMATION_H
#define _MD3_ANIMATION_H

#include <string>

namespace md3
{

typedef enum MD3AnimationType {
  LEGS      = 0,             //!< animation only applicatble to the legs. top level model loaded from lower.md3
  TORSO,                     //!< animation only applicatboe to the torso. normaly loaded from upper.md3
  BOTH,                      //!< animation is applicable on both
  ALL,                       //!< animation is applicable to all submodels

  NUM_ANIMATION_TYPE         //!< number of animations
};


typedef struct MD3AnimationMap {
  std::string        animationName;
  MD3AnimationType   animationType;
};




/**
 * a class with metadata describing an MD3 model animation
 */
class MD3Animation
{

  public:
    MD3Animation();
    virtual ~MD3Animation();

    void init();

    std::string toString() { return std::string("Name: " + this->name); }


  public:
    MD3AnimationType      type;                      //!< specifies for what parts of a model this animation is appilcable (e.g. LEGS)
    std::string           name;                      //!< name of the animation

    int                   offset;                    //!< for LEGS animation, this is the offset value to skip TORSO frames
    int                   first;                     //!< first frame
    int                   numFrames;                 //!< the number of frames in the anumation. < 0 means that all available frames used
    int                   numLoopFrames;             //!< number of looping frames
    int                   fps;                       //!< frames per second

    static MD3AnimationMap animationList[25];         //!< the animation list
};

}
#endif /* _MD3_ANIMATION_H */
