/*!
 * @file TerrainEntity.h

  *  Defines and handles the TerrainEntity of the World

    @todo implement it

    The TerrainEntity should either be build from a Model a OBJModel or from a HeightMap.
*/

#ifndef _TERRAINENTITY_H
#define _TERRAINENTITY_H

#include "world_entity.h"
#include "vector.h"

// FORWARD DECLARATION
class Material;
class Terrain;

//! A simple method to call a desired debug world.
enum DebugTerrainEntity {TERRAINENTITY_DAVE, TERRAINENTITY_BENSCH};


//! A Class to handle TerrainEntity of orxonox
class TerrainEntity : public WorldEntity
{

	public:
		TerrainEntity(const TiXmlElement* root = NULL);
		TerrainEntity(const std::string& fileName);
		TerrainEntity(DebugTerrainEntity debugTerrainEntity);
		virtual ~TerrainEntity();

		void init();
		virtual void loadParams(const TiXmlElement* root);

		void loadVegetation(const std::string& vegetationFile);

		void loadElevationmap( const std::string& _eleFile );
		void loadLightmap(const std::string& _lightFile );
		void setScale( float x, float y, float z );

		void buildDebugTerrainEntity(DebugTerrainEntity debugTerrainEntity);

		float getHeight(float x, float y);
		virtual void draw() const;

	public:
	
	private:
		 Model*              	vegetation;
		 int                 	objectList;
		 Terrain*				terrain;
		 Vector              	TerrainEntityScale;
};

#endif /* _TerrainEntity_H */
