/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD


#include "multi_player_world_data.h"

#include "util/loading/resource_manager.h"
#include "state.h"
#include "class_list.h"
#include "substring.h"

#include "util/loading/game_loader.h"
#include "cd_engine.h"

#include "p_node.h"
#include "world_entity.h"
#include "player.h"
#include "camera.h"
#include "environment.h"
#include "terrain_entity.h"
#include "test_entity.h"
#include "md2/md2Model.h"
#include "world_entities/projectiles/projectile.h"
#include "npcs/npc_test1.h"
#include "playable.h"

#include "util/loading/factory.h"
#include "fast_factory.h"
#include "util/loading/load_param.h"

#include "network_manager.h"
#include "network_game_manager.h"
#include "player_stats.h"


#include "glmenu_imagescreen.h"



using namespace std;


/**
 * constructor of the GameWorldDataData
 */
MultiPlayerWorldData::MultiPlayerWorldData()
    : GameWorldData()
{
  this->toggle = false;
}


/**
 * destructor for the GameWorldDataData
 */
MultiPlayerWorldData::~MultiPlayerWorldData()
{}


/**
 *  initialize the GameWorldDataData
 */
ErrorMessage MultiPlayerWorldData::init()
{
  /* call underlying function */
  GameWorldData::init();
}


/**
 *  loads the GUI data
 * @param root reference to the xml root element
 */
ErrorMessage MultiPlayerWorldData::loadGUI(const TiXmlElement* root)
{
  /* call underlying function */
  GameWorldData::loadGUI(root);
}


/**
 *  unloads the GUI data
 */
ErrorMessage MultiPlayerWorldData::unloadGUI()
{
  /* call underlying function */
  GameWorldData::unloadGUI();
}


/**
 *  overloads the GameWorld::loadWorldEntities(...) class since the network WorldEntity loading is different
 * @param root reference to the xml root parameter
 */
ErrorMessage MultiPlayerWorldData::loadWorldEntities(const TiXmlElement* root)
{
  /* load the spawning points */
  const TiXmlElement* element = root->FirstChildElement("SpawningPoints");
  if( element == NULL)
  {
    PRINTF(1)("NetworkWorld is missing 'SpawningPoints'\n");
  }
  else
  {
    element = element->FirstChildElement();
    // load Players/Objects/Whatever
    PRINTF(4)("Loading Spawning Points\n");
    while( element != NULL)
    {
      BaseObject* created = Factory::fabricate(element);
      if( created != NULL )
        printf("Created a Spawning Point %s: %s\n", created->getClassName(), created->getName());

      element = element->NextSiblingElement();
      glmis->step();
    }
    PRINTF(4)("Done loading Spawning Points\n");
  }

  /* load the WorldEntities */
  element = root->FirstChildElement("WorldEntities");
  if( element == NULL)
  {
    PRINTF(1)("NetworkWorld is missing 'WorldEntities'\n");
  }
  else
  {
    element = element->FirstChildElement();

    if( NetworkManager::getInstance()->isGameServer() )
    {
      while( element != NULL)
      {
        /* pass the entity to the NetworkGameManager to be created */
        BaseObject* created = Factory::fabricate(element);
        if( created != NULL )
          PRINTF(1)("Created a %s: %s (0x%8x) from %s\n", created->getClassName(), created->getName(), created->getLeafClassID(), element->Value());
        else
          PRINTF(1)("NetworkWorld: could not create this entity\n");

        if( element->Value() != NULL && !strcmp( element->Value(), "SkyBox"))
          this->sky = dynamic_cast<WorldEntity*>(created);
        if( element->Value() != NULL && !strcmp( element->Value(), "Terrain"))
        {
          this->terrain = dynamic_cast<TerrainEntity*>(created);
          CDEngine::getInstance()->setTerrain(terrain);
        }

        element = element->NextSiblingElement();


        glmis->step();
        PRINTF(4)("Done loading NetworkWorldEntities\n");
      }
    }
    else
    {
      while( element != NULL)
      {
        PRINTF(0)("load: %s\n", element->Value());
        if( !strcmp(element->Value(), "Terrain") || !strcmp(element->Value(), "Building")  )
        {

          /* pass the entity to the NetworkGameManager to be created */
          BaseObject* created = Factory::fabricate(element);

          if( created != NULL )
            PRINTF(1)("Created a %s: %s (0x%8x) from %s\n", created->getClassName(), created->getName(), created->getLeafClassID(), element->Value());
          else
            PRINTF(1)("NetworkWorld: could not create this entity\n");

          if( element->Value() != NULL && !strcmp( element->Value(), "SkyBox"))
            this->sky = dynamic_cast<WorldEntity*>(created);
          if( element->Value() != NULL && !strcmp( element->Value(), "Terrain"))
          {
            this->terrain = dynamic_cast<TerrainEntity*>(created);
            CDEngine::getInstance()->setTerrain(terrain);
          }

          glmis->step();
          PRINTF(4)("Done loading NetworkWorldEntities\n");
        }
        element = element->NextSiblingElement();
      }
    }


    if( NetworkManager::getInstance()->isGameServer())
    {
      this->localPlayer = new Player();

#if 0
      Playable* playable;
      const std::list<BaseObject*>* playableList = ClassList::getList(CL_PLAYABLE);
      assert( playableList != NULL);

      if (playableList != NULL)
      {
        playable = dynamic_cast<Playable*>(playableList->front());
        this->localPlayer->setPlayable(playable);
        playable->toList(OM_GROUP_00);
        playable->setAbsCoor(213.37, 57.71, -47.98);
        playable->setPlayDirection(Quaternion(M_PI, Vector(0.0, 1.0, 0.0)));
      }
#endif
    }
    else
    {
      /* create a Player */
      this->localPlayer = new Player();
    }


    /* init the pnode tree */
    PNode::getNullParent()->init();
  }
    // Fill the EntityLists. Tick then Draw:
  this->tickLists.push_back(OM_DEAD_TICK);
  this->tickLists.push_back(OM_ENVIRON);
  this->tickLists.push_back(OM_COMMON);
  this->tickLists.push_back(OM_GROUP_00);
  this->tickLists.push_back(OM_GROUP_00_PROJ);
  this->tickLists.push_back(OM_GROUP_01);
  this->tickLists.push_back(OM_GROUP_01_PROJ);

  this->drawLists.push_back(OM_ENVIRON_NOTICK);
  this->drawLists.push_back(OM_ENVIRON);
  this->drawLists.push_back(OM_COMMON);
  this->drawLists.push_back(OM_GROUP_00);
  this->drawLists.push_back(OM_GROUP_00_PROJ);
  this->drawLists.push_back(OM_GROUP_01);
  this->drawLists.push_back(OM_GROUP_01_PROJ);
  
  State::setPlayer(this->localPlayer);
 
}


/**
 *  unloads the world entities from the xml file
 */
ErrorMessage MultiPlayerWorldData::unloadWorldEntities()
{
  /* call underlying function */
  GameWorldData::unloadWorldEntities();
}


/**
 *  loads the scene data
 * @param root reference to the xml root element
 */
ErrorMessage MultiPlayerWorldData::loadScene(const TiXmlElement* root)
{
  /* call underlying function */
  GameWorldData::loadScene(root);
  
  // create server playable
  if ( NetworkManager::getInstance()->isGameServer() )
  {
    NetworkGameManager::getInstance()->signalNewPlayer( 0 );
    State::getPlayer()->setPlayable( PlayerStats::getStats( 0 )->getPlayable() );
  }
}


/**
 *  unloads the scene data
 */
ErrorMessage MultiPlayerWorldData::unloadScene()
{
  /* call underlying function */
  GameWorldData::unloadScene();
}


/**
 * some debug output
 */
void MultiPlayerWorldData::debug()
{
  PRINT(0)("==================================================\n");
  Playable* playable;
  const std::list<BaseObject*>* playableList = ClassList::getList(CL_PLAYABLE);
  assert(playableList != NULL);
  std::list<BaseObject*>::const_iterator entity;



  for (entity = playableList->begin(); entity != playableList->end(); entity++)
  {
    Playable* p = dynamic_cast<Playable*>(*entity);
    PRINTF(0)("Got a playable, class: %s, name: %s, uid: %i\n", (*entity)->getClassName(), (*entity)->getName(), p->getUniqueID());
  }


  if( this->toggle)
  {
    playable = dynamic_cast<Playable*>(playableList->front());
    this->localPlayer->setPlayable(playable);
    this->toggle = !this->toggle;
  }
  else
  {
    playable = dynamic_cast<Playable*>(playableList->back());
    this->localPlayer->setPlayable(playable);
    this->toggle = !this->toggle;
  }


  Playable* pl = this->localPlayer->getPlayable();
  PRINTF(0)("The current regisered playable is hid: %i\n", pl->getUniqueID());


  PNode* cam = State::getCameraTargetNode();
  PRINT(0)("Camera has target - class: %s, name: %s, uid: %i\n", cam->getClassName(), cam->getName(), cam->getUniqueID());

  PRINT(0)("==================================================\n");

}


















