/*
	orxonox - the future of 3D-vertical-scrollers
 
	Copyright (C) 2006 orx
 
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.
 
	### File Specific:
	main programmer: Marco Biasini
 	This files needs to be removed after code-revision...
 */
#ifndef TYPES_H
#define TYPES_H

#ifndef NULL
#define NULL 0
#endif
#include <math.h>


struct Triple {
	Triple( float _x, float _y, float _z ) 
	{ 
		x = _x; y = _y; z = _z; 
	}
	Triple() { x = y = z = 0.0f; }
	inline float length() const
	{ return sqrt( x*x+y*y+z*z ); } 
	float x, y, z;
};

struct TexCoord {
	TexCoord( float _u, float _v )
	{
		u = _u; v = _v;
	}
	TexCoord() { u = v = 0.0f; }
	float u, v;
};

/**
 * Defines an axis aligned box.
 */
struct ABox {
	
	ABox( Triple _min, Triple _max)
	{
		corner = _min;
		x = _max.x-_min.x;
		y = _max.y-_min.y;
		z = _max.z-_min.z;
	}
	
	ABox() 
	{
		corner = Triple( 0.0f, 0.0f, 0.0f );
		x = y = z = 0.0f;
	}
	inline void set( const Triple& _min, const Triple& _max )
	{
		setMin( _min ); setMax( _max );
	}
	inline void setMax( const Triple& _max )
	{
		x = _max.x-corner.x;
		y = _max.y-corner.y;
		z = _max.z-corner.z;
	}
	inline void setMin( const Triple& _min )
	{
		corner = _min;
	}
	inline Triple vertexP( const Triple& _normal ) const 
	{
		Triple res = corner;
		if ( _normal.x > 0 )
			res.x+= x;
		if ( _normal.y > 0 )
			res.y+= y;
		if ( _normal.z > 0 )
			res.z+= z;			
			
		return res;
	}
	inline Triple vertexN( const Triple& _normal ) const
	{		
		Triple res = corner;
		if ( _normal.x < 0 )
			res.x+= x;
		if ( _normal.y < 0 )
			res.y+= y;
		if ( _normal.z < 0 )
			res.z+= z;			
			
		return res;
	
	}
	inline Triple min() const { return Triple(corner); }
	inline Triple max() const { return Triple( corner.x+x, corner.y+y, corner.z+z ); }
	Triple corner;
	float x, y, z;
	
};

struct Plane {
	Plane() { n = Triple( 0.0f, 1.0f, 0.0f ); d = 0.0f; }
	inline void setCoefficients( float _nx, float _ny, float _nz, float _d )
	{
		n = Triple( _nx, _ny, _nz );
		float l = n.length();
		n.x /= l; n.y/=l; n.z/=l;
		d = _d/l;
	}
	inline float distance( const Triple& _point ) const
	{
		return _point.x*n.x+_point.y*n.y+_point.z*n.z+d;
	}
	Triple n;
	float d;
};

/**
 * TODO: Replace this method with the actual matrix multiplication code!
 */
inline void multMat(float *res,float *a, float *b) {


	for (int i=0;i<4;i++) {
		for (int j = 0;j < 4;j++) {
			res[i*4+j] = 0.0;
			for (int k = 0; k < 4; k++) {
				res[i*4+j] += a[i*4+k] * b[k*4+j];
			}
		}
	}
}
typedef unsigned char UByte;
#endif