/*
	orxonox - the future of 3D-vertical-scrollers
 
	Copyright (C) 2006 orx
 
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.
 
	### File Specific:
	main programmer: Marco Biasini
 
 */
#ifndef _TERRAIN_QUAD_TREE_H
#define _TERRAIN_QUAD_TREE_H

#include "types.h"
#include "frustum.h"
#include <stdio.h>
class Terrain;
class TerrainQuad;
typedef TerrainQuad *pTerrainQuad;

typedef enum { TL_CHILD = 0, TR_CHILD = 1, BL_CHILD = 2, BR_CHILD = 3 } TerrainQuadChild;
	
class TerrainQuad {
	public:
		TerrainQuad( Terrain *_owner, int _xOffset, int _zOffset );
		TerrainQuad( Terrain *_owner, int _x0, int _z0, int _x1, int _z1 );
		
		virtual ~TerrainQuad( ) 
		{
			for ( int i = 0; i < 4; ++i )
				if ( children[i] != NULL )
					delete children[i];					
		}
		int cull( );
		
		/**
		 * Returns the array containing the children quad-nodes of this node in the following
		 * order: top-left, top-right, bottom-left, bottom-right
		 */
		inline pTerrainQuad* getChildren( ) 
		{ 
			return children; 
		}
		
		/**
		 * Sets the child-nodes to the specified _children elements.
		 */
		void setChildren( pTerrainQuad _children[] )
		{
			for ( int i = 0; i < 4; ++i )
				children[i] = _children[i];
		}
		
		inline bool isChildless() { return ( children[0] == NULL ); }
		
		/**
		 * Returns the child node given by _child. The returned node may be null.
		 */
		inline pTerrainQuad getChild( TerrainQuadChild _child ) 
		{ 
			return children[_child]; 
		}
		inline void setScale( Triple _scale )
		{
			scale = _scale;
		}
		inline const ABox getBounds() { return bounds; }
		inline void setChildren( pTerrainQuad _bl, pTerrainQuad _br, pTerrainQuad _tl,
			pTerrainQuad _tr )
		{
			children[TL_CHILD] = _tl;
			children[TR_CHILD] = _tr;
			children[BR_CHILD] = _br;
			children[BL_CHILD] = _bl;
		}
		/**
		 * Calculates the mininum and maximum value of this box based on the size
		 * and position of its children.
		 */
		virtual void calculateBounds( );
		inline int getXOffset() { return xOffset; }
		inline int getZOffset() { return zOffset; }
		inline int getWidth() { return width; }
		inline int getHeight() { return height; }
		
	protected:
		TerrainQuad( ) {}
		Terrain			*owner;
		int				xOffset, zOffset;
		int				width,	height;
		Triple			scale;
		pTerrainQuad 	children[4];
		ABox			bounds;
};

#endif