/*
	orxonox - the future of 3D-vertical-scrollers
 
	Copyright (C) 2006 orx
 
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.
 
	### File Specific:
	main programmer: Marco Biasini
 
 */
#include "terrain_quad.h"
#include "terrain.h"
#include <math.h>

TerrainQuad::TerrainQuad( Terrain *_owner, int _xOffset, int _zOffset )
: owner( _owner ), xOffset( _xOffset ), zOffset( _zOffset ), width( 1 ), height( 1 )
{
	scale = owner->getScale();
}

TerrainQuad::TerrainQuad( Terrain *_owner, int _x0, int _z0, int _x1, int _z1 )
:	owner( _owner ), xOffset( _x0 ), zOffset( _z0 ), 
width( _x1-_x0 ), height( _z1-_z0 )
{
	//printf( "%d, %d, %d, %d\n", xOffset, zOffset, width, height );
	scale = owner->getScale();
}

int TerrainQuad::cull()
{
	return owner->getViewingFrustum()->boxInFrustum( bounds );
}

/** 
 * Recalculate the bounds of this TerrainQuad. It could be optimized, but how
 * often is this method really used?
 */
void TerrainQuad::calculateBounds()
{
	if ( isChildless() ) {
		printf( "Cannot calculate bounds for a childless terrain quad.\n" );
		exit( 0 );
	}	
	Triple min = Triple( children[BL_CHILD]->getBounds().min() );
	Triple max = Triple( children[TR_CHILD]->getBounds().max() );
	for ( int i = 1; i < 4; ++i ) {
		pTerrainQuad child = children[i];
		min.y = fmin( child->bounds.min().y, min.y );
		max.y = fmax( child->bounds.max().y, max.y );		
	}
	bounds.set( min, max );
}