/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*!
 * @file debug.h
 * @briefHandles output to console for different Verbose-Modes.
 *
 * There are two main modes HARD and SOFT. HARD is precessed during compileTime where SOFT is for runtime.
 * @li HARD: One can choose between different modes. see: // DEFINE_MODULES
 * @li SOFT: If you want each module can have its own variable for processing. just pass it to DEBUG_MODULE_SOFT
 */

#ifndef _DEBUG_H
#define _DEBUG_H

#include "confincl.h"
#ifndef NO_SHELL
#include "lib/shell/shell_buffer.h"
#endif /* NO_SHELL */

#include <stdio.h>
#include <cassert>

// DEFINE ERROR MODES
#define ORX_NONE            0
#define ORX_ERR             1
#define ORX_WARN            2
#define ORX_INFO            3
#define ORX_DEBUG           4
#define ORX_vDEBUG          5

extern int verbose;

//definitions
#ifndef MODULAR_DEBUG
 #define HARD_DEBUG_LEVEL ORX_DEBUG
 #define SOFT_DEBUG_LEVEL verbose
#else /* MODULAR_DEBUG */
 #ifndef DEBUG_MODULE_SOFT
  #define SOFT_DEBUG_LEVEL verbose
 #else /* DEBUG_MODULE_SOFT */
  #define SOFT_DEBUG_LEVEL DEBUG_MODULE_SOFT
 #endif /* DEBUG_MODULE_SOFT */

 #ifndef DEBUG_SPECIAL_MODULE
  #define HARD_DEBUG_LEVEL DEBUG
 #else /* DEBUG_SPECIAL_MODULE */
  ////////////////////
  // DEFINE MODULES //
  ////////////////////
  // FRAMEWORK
  #define DEBUG_MODULE_BASE                  2
  #define DEBUG_MODULE_ORXONOX               2
  #define DEBUG_MODULE_WORLD                 2
  #define DEBUG_MODULE_NETWORK               2

  // LOADING
  #define DEBUG_MODULE_LOAD                  2
  #define DEBUG_MODULE_IMPORTER              2

  // ENGINES
  #define DEBUG_MODULE_GRAPHICS              2
  #define DEBUG_MODULE_EVENT                 2
  #define DEBUG_MODULE_PHYSICS               2
  #define DEBUG_MODULE_GARBAGE_COLLECTOR     2
  #define DEBUG_MODULE_OBJECT_MANAGER        2
  #define DEBUG_MODULE_ANIM                  2
  #define DEBUG_MODULE_COLLISION_DETECTION   2
  #define DEBUG_MODULE_COLLISION_REACTION    2
  #define DEBUG_MODULE_SPATIAL_SEPARATION    2
  #define DEBUG_MODULE_GUI                   2
  #define DEBUG_MODULE_SOUND                 2

  // MISC
  #define DEBUG_MODULE_TRACK_MANAGER         2
  #define DEBUG_MODULE_MATH                  2

  #define DEBUG_MODULE_PNODE                 2
  #define DEBUG_MODULE_WORLD_ENTITY          2

  #define DEBUG_MODULE_STORY_ENTITY          2
  #define DEBUG_MODULE_GAME_RULES            2

  #define DEBUG_MODULE_WEAPON                2

  #define HARD_DEBUG_LEVEL DEBUG_SPECIAL_MODULE

 #endif /* DEBUG_SPECIAL_MODULE */
#endif /* MODULAR_DEBUG */

///////////////////////////////////////////////////
/// PRINTF: prints with filename and linenumber ///
///////////////////////////////////////////////////
#define PRINTFORX_NONE    PRINTF0
#define PRINTFORX_ERR     PRINTF1
#define PRINTFORX_WARN    PRINTF2
#define PRINTFORX_INFO    PRINTF3
#define PRINTFORX_DEBUG   PRINTF4
#define PRINTFORX_VDEBUG  PRINTF5

#ifndef ORX_DATADIR
#define ORX_DATADIR "/usr/share"
#endif
#ifndef DEBUG_LEVEL
#define DEBUG_LEVEL 2
#endif
#if DEBUG_LEVEL <= 3
#define PRINTF(x)        PRINT(x)
#endif
#ifndef NO_SHELL
#define PRINT_EXEC       OrxShell::ShellBuffer::addBufferLineStatic
#define COUT_EXEC        std::cout
#else /* NO_SHELL */
#define PRINT_EXEC       printf
#define COUT_EXEC        std::cout
#endif

#ifndef PRINTF
#ifdef ORX_DEBUG

#define PRINTF(x) \
           PRINTF ## x

#if HARD_DEBUG_LEVEL >= ORX_ERR
#define PRINTF1 \
    if (SOFT_DEBUG_LEVEL >= ORX_ERR) \
      printf("(EE)::%s:%d:", __FILE__, __LINE__), PRINT_EXEC
#else
#define PRINTF1 if (ORX_NONE) PRINT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_WARN
#define PRINTF2 \
     if (SOFT_DEBUG_LEVEL >= ORX_WARN) \
       printf("(WW)::%s:%d:", __FILE__, __LINE__), PRINT_EXEC

#else
#define PRINTF2 if (ORX_NONE) PRINT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_INFO
#define PRINTF3 \
     if (SOFT_DEBUG_LEVEL >= ORX_INFO) \
       printf("(II)::%s:%d:", __FILE__, __LINE__), PRINT_EXEC
#else
#define PRINTF3 if (ORX_NONE) PRINT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_DEBUG
#define PRINTF4 \
     if (SOFT_DEBUG_LEVEL >= ORX_DEBUG) \
       printf("(DD)::%s:%d:", __FILE__, __LINE__), PRINT_EXEC
#else
#define PRINTF4 if (ORX_NONE) PRINT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_vDEBUG
#define PRINTF5 \
     if (SOFT_DEBUG_LEVEL >= ORX_vDEBUG) \
       printf("(VD)::%s:%d:", __FILE__, __LINE__), PRINT_EXEC
#else
#define PRINTF5 if (ORX_NONE) PRINT_EXEC
#endif

#else
#define PRINTF(x) if (ORX_NONE) PRINT_EXEC
#endif

#define PRINTF0 \
    printf("%s:%d::", __FILE__, __LINE__), PRINT_EXEC
#endif

///////////////////////////////////////////////////
///  PRINT: just prints output as is            ///
///////////////////////////////////////////////////
#define PRINTORX_NONE    PRINT0
#define PRINTORX_ERR     PRINT1
#define PRINTORX_WARN    PRINT2
#define PRINTORX_INFO    PRINT3
#define PRINTORX_DEBUG   PRINT4
#define PRINTORX_vDEBUG  PRINT5

#ifdef  DEBUG_LEVEL
#define PRINT(x) \
  PRINT ## x

#if HARD_DEBUG_LEVEL >= ORX_ERR
#define PRINT1  \
  if (SOFT_DEBUG_LEVEL >= ORX_ERR)  \
    PRINT_EXEC
#else
#define PRINT1 if (ORX_NONE) PRINT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_WARN
#define PRINT2 \
  if (SOFT_DEBUG_LEVEL >= ORX_WARN) \
    PRINT_EXEC

#else
#define PRINT2 if (ORX_NONE) PRINT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_INFO
#define PRINT3 \
  if (SOFT_DEBUG_LEVEL >= ORX_INFO) \
    PRINT_EXEC
#else
#define PRINT3 if (ORX_NONE) PRINT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_DEBUG
#define PRINT4 \
  if (SOFT_DEBUG_LEVEL >= ORX_DEBUG) \
    PRINT_EXEC
#else
#define PRINT4 if (ORX_NONE) PRINT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_vDEBUG
#define PRINT5 \
     if (SOFT_DEBUG_LEVEL >= ORX_vDEBUG) \
       PRINT_EXEC
#else
#define PRINT5 if (ORX_NONE) PRINT_EXEC
#endif


#else
#define PRINT(x) if (ORX_NONE) PRINT_EXEC
#endif

#define PRINT0 \
  PRINT_EXEC



////////////////////////////////////////////////////////
///  COUT: just prints output as is with std::cout   ///
////////////////////////////////////////////////////////
#define COUTORX_NONE    COUT0
#define COUTORX_ERR     COUT1
#define COUTORX_WARN    COUT2
#define COUTORX_INFO    COUT3
#define COUTORX_DEBUG   COUT4
#define COUTORX_vDEBUG  COUT5

#ifdef  DEBUG_LEVEL
#define COUT(x) \
  COUT ## x

#if HARD_DEBUG_LEVEL >= ORX_ERR
#define COUT1  \
  if (SOFT_DEBUG_LEVEL >= ORX_ERR)  \
    COUT_EXEC
#else
#define COUT1 if (ORX_NONE)\
    COUT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_WARN
#define COUT2 \
  if (SOFT_DEBUG_LEVEL >= ORX_WARN) \
    COUT_EXEC

#else
#define COUT2 if (ORX_NONE) \
    COUT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_INFO
#define COUT3 \
  if (SOFT_DEBUG_LEVEL >= ORX_INFO) \
    COUT_EXEC
#else
#define COUT3 if (ORX_NONE) \
    COUT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_DEBUG
#define COUT4 \
  if (SOFT_DEBUG_LEVEL >= ORX_DEBUG) \
    COUT_EXEC
#else
#define COUT4 if (ORX_NONE) \
    COUT_EXEC
#endif

#if HARD_DEBUG_LEVEL >= ORX_vDEBUG
#define COUT5 \
     if (SOFT_DEBUG_LEVEL >= ORX_vDEBUG) \
       COUT_EXEC
#else
#define COUT5 if (ORX_NONE) \
    COUT_EXEC
#endif


#else
#define COUT(x) if (ORX_NONE) \
    COUT_EXEC
#endif

#define COUT0 \
  COUT_EXEC


#endif /* _DEBUG_H */
