/*!
 * @file shell.h
 * Definition of a on-screen-shell
 *
 * @todo Buffer Display in different Colors for different debug mode.
 * @todo choose color of the Font and the background.
 */

#ifndef _GLGUI_NOTIFIER_H
#define _GLGUI_NOTIFIER_H

#include "glgui_widget.h"
#include "event_listener.h"

#include <stack>

// FORWARD DECLARATION
class MultiLineText;
class Text;

//! Namespace of the GLGuiNotifier of ORXONOX.
namespace OrxGui
{
  class GLGuiNotifier : public GLGuiWidget
  {
  public:
    GLGuiNotifier();
    virtual ~GLGuiNotifier();

    void pushNotifyMessage(const std::string& message);

    /// Setup
    void setDisplayLineCount(unsigned int count);
    void setFadeAge(float fadeAge);
    void setHideAge(float hideAge);

    /** @returns the beginning of the Hiding process */
    inline float fadeAge() const { return _fadeAge; };
    /** @returns at what age elements should be fully hidden */
    inline float hideAge() const { return _hideAge; };

    void clear();

    // Element2D-functions
    virtual void tick(float dt);
    virtual void draw() const;

    void debug() const;

  protected:
    virtual void resize();

  private:
    void repositionText();
    void applyTextSettings(MultiLineText* text);
    void applySettings();
    // helpers //
    Vector2D calculateLinePosition(unsigned int lineNumber);



  private:
    //! structure that defines a Displayed line.
    typedef struct
    {
      float             age;
      MultiLineText*    text;

    } DisplayLine;


    float                       _fadeAge;
    float                       _hideAge;
    float                       _transformAge;

    unsigned int                lineSpacing;            //!< The Spacing between lines.

    // BUFFER
    unsigned int                bufferDisplaySize;      //!< The Size of the Display-buffer, in lines (not in characters).
    std::list<DisplayLine>      displayLines;           //!< A list of stored bufferTexts for the display of the buffer.

    std::stack<MultiLineText*>  hiddenText;             //!< Text that is not shown, and not used is thrown in here


    unsigned long               linesProcessed;         //!< How many Lines have been processed so far.
    std::list<std::string>      inputBuffer;            //!< The input buffer for lines that were not yet printet out, because there is too much input.

  };

}

#endif /* _GLGUI_NOTIFIER_H */
