/*!
 * @file glgui_table.h
 * The gl_TABLE widget of th openglGUI
 *
 */

#ifndef _GLGUI_TABLE_H
#define _GLGUI_TABLE_H

#include "glgui_widget.h"
#include "limited_width_text.h"
#include "event.h"

// FORWARD DECLARATION
namespace OrxGui
{

  //! This is Table part of the openglGUI class
  /**
   * The Table is a Widget, that displays a Line, that can be manipulated through
   * Writing Text on it.
   *
   * Whenever the Text is changed the textChanged signal is emitted.
   */
  class GLGuiTable : public OrxGui::GLGuiWidget
  {

  public:
    GLGuiTable(unsigned int rows, unsigned int columns);
    virtual ~GLGuiTable();

    unsigned int rowCount() const { return this->_entries.size(); };
    unsigned int columnCount() const { return this->_headers.size(); };

    void setRowCount(unsigned int rowCount);
    void setColumnCount(unsigned int columnCount);

    void setHeader(unsigned int number, const std::string& headerName);
    void setHeader(const std::vector<std::string>& headerNames);

    void setEntry(unsigned int column, unsigned int row, const std::string& name);

    void setColumnWidth(unsigned int column, float size);
    void setRowHeight(unsigned int row, unsigned int size);

    virtual void tick(float dt);
    virtual void draw() const;


    void debug() const;

  protected:
    virtual void removedFocus();

    virtual void updateFrontColor();
    virtual void hiding();
    virtual void showing();
    virtual void resize();

    virtual bool processEvent(const Event& event);


  private:
    void init();

    void applyTextSettings(unsigned int row, unsigned int column, LimitedWidthText* text);
    bool checkIntegrity() const;

  private:
    typedef std::vector<LimitedWidthText> TableTextList;
    TableTextList                _headers;
    std::vector<TableTextList>   _entries;     //!< inner is by column, outer is by row.


  };
}

#endif /* _GLGUI_TABLE_H */
