/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_image.h"

#include "debug.h"

namespace OrxGui
{

  /**
   * standard constructor
  */
  GLGuiImage::GLGuiImage ()
  {
    this->init();

  }


  /**
   * standard deconstructor
  */
  GLGuiImage::~GLGuiImage()
  {
  }

  /**
   * initializes the GUI-element
   */
  void GLGuiImage::init()
  {
    this->setClassID(CL_GLGUI_IMAGE, "GLGuiImage");

    this->setForegroundColor(Color(1,1,1,1));
    this->_imageMaterial.setBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    this->resize();
  }


  void GLGuiImage::loadImageFromTexture(const Texture& texture)
  {
    this->_imageMaterial.setDiffuseMap(texture);
  }

  void GLGuiImage::loadImageFromFile(const std::string& fileName)
  {
    this->_imageMaterial.setDiffuseMap(fileName);
  }

  void GLGuiImage::loadImageFromSDLSurface(SDL_Surface* surface)
  {
    this->_imageMaterial.setDiffuseMap(Texture(surface));
  }

  void GLGuiImage::loadImageFromDisplayList(GLuint texture)
  {
    PRINTF(2)("SORRY NOT IMPLEMENTED\n");
//    this->_imageMaterial.setTexture(texture);
  }

  void GLGuiImage::updateFrontColor()
  {
    this->_imageMaterial.setDiffuseColor(foregroundColor());
  }

  void GLGuiImage::resize()
  {
    this->_imagePlane.setTopLeft(borderLeft(), borderTop());
    this->_imagePlane.setSize(this->getSizeX2D() - (borderLeft() + borderRight()), this->getSizeY2D() - (borderTop() + borderBottom()) );
    GLGuiWidget::resize();
  }


  /**
   * @brief draws the GLGuiImage
   */
  void GLGuiImage::draw() const
  {
    this->beginDraw();
    GLGuiWidget::draw();

    this->_imageMaterial.select();
    this->drawRect(this->_imagePlane);
    this->endDraw();
  }
}
