/*!
 * @file glgui_button.h
 * The gl_BUTTON widget of th openglGUI
 *
 */

#ifndef _GLGUI_BUTTON_H
#define _GLGUI_BUTTON_H

#include "glgui_widget.h"

#include "text.h"

namespace OrxGui
{
  typedef enum
  {
    Button_Active,
    Button_Inactive,
    Button_Pressed,
    Button_Released,
    Button_Activating,
    Button_Deactivating,

  } ButtonState;

  //! This is part of the openglGUI class
  /**
   * The Button is an Abstract class, that can be pushed to Toggle its state.
   */
  class GLGuiButton : public GLGuiWidget
  {

    public:
      GLGuiButton(const std::string& label);
      virtual ~GLGuiButton();

      const std::string& label() const { return this->_label.text(); };
      void setLabel(const std::string& label);

      virtual void draw() const;

      DeclareSignal0(clicked);
      DeclareSignal0(released);

    protected:
      virtual void updateFrontColor();

      virtual void clicking(const Vector2D& pos);
      virtual void releasing(const Vector2D& pos);
      virtual void hiding();
      virtual void showing();

      /** @returns the Text. (the physical Text) */
      Text& labelText() { return this->_label; }
      /** @returns the constant Text. (the physical Text) */
      const Text& labelText() const { return this->_label; }

    private:
      void init();


    private:
      Text                 _label;
      ButtonState          state;
  };
}
#endif /* _GLGUI__H */
