/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_button.h"

#include "text.h"


namespace OrxGui
{
  /**
   * standard constructor
  */
  GLGuiButton::GLGuiButton (const std::string& label)
  {
    this->init();

    this->_label.setText( label );
  }


  /**
   * standard deconstructor
  */
  GLGuiButton::~GLGuiButton()
  {
    /* this does not have to be done, since the Label is a child,
     * and will be deleted by Element2D's deletion Process
     * delete this->label;
    */
  }

  /**
   * @brief initializes the GUI-element
   */
  void GLGuiButton::init()
  {
    this->setClassID(CL_GLGUI_BUTTON, "GLGuiButton");
    this->setFocusable(true);
    this->setClickable(true);

    this->_label.setFont("fonts/final_frontier.ttf", 20);
    this->_label.setColor(this->foregroundColor() );

    this->_label.setParent2D(this);
    this->_label.setVisibility(false);
  }


  void GLGuiButton::setLabel(const std::string& label)
  {
    this->_label.setText(label);
    this->resize();
  }


  void GLGuiButton::updateFrontColor()
  {
    this->_label.setColor(this->foregroundColor());
  }

  void GLGuiButton::clicking(const Vector2D& pos)
  {
    GLGuiWidget::clicking(pos);
    emit(clicked());
  }
  void GLGuiButton::releasing(const Vector2D& pos)
  {
    GLGuiWidget::releasing(pos);
    emit(released());
  }

  void GLGuiButton::hiding()
  {
    this->_label.setVisibility(false);
  }

  void GLGuiButton::showing()
  {
    this->_label.setVisibility(true);
  }


  /**
   * @brief draws the GLGuiButton
   */
  void GLGuiButton::draw() const
  {
    GLGuiWidget::draw();
  }
}
