/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_checkbutton.h"

#include "text.h"

namespace OrxGui
{


  /**
   * standard constructor
  */
  GLGuiCheckButton::GLGuiCheckButton (const std::string& label, bool active)
  : GLGuiButton(label)
  {
    this->init();
    this->bActive = active;

    this->resize();
  }


  /**
   * standard deconstructor
  */
  GLGuiCheckButton::~GLGuiCheckButton()
  {
  }

  /**
   * initializes the GUI-element
   */
  void GLGuiCheckButton::init()
  {
    this->setClassID(CL_GLGUI_CHECKBUTTON, "GLGuiCheckButton");
  }

  void GLGuiCheckButton::setActivity(bool bActive)
  {
    this->bActive = bActive;
    emit(this->toggled(this->bActive));
  }

  void GLGuiCheckButton::toggleActiveState()
  {
    this->setActivity(!this->isActive());
  }

  void GLGuiCheckButton::resize()
  {

    this->labelText().setRelCoor2D( borderLeft() + 15.0, borderTop() + 5);
    this->setSize2D(this->labelText().getSizeX2D() + 15.0 + borderLeft() + borderRight(), this->labelText().getSizeY2D() + 10 + borderTop()+borderBottom());
    GLGuiWidget::resize();

    this->_checkBox.setSize(10.0, 10.0);
    this->_checkBox.setCenter( borderLeft() + _checkBox.height()/2.0, borderTop() + (this->getSizeY2D() - borderTop() - borderBottom()) / 2.0);

/*    this->frontRect().setTopLeft(borderLeft(), borderTop());
    this->frontRect().setSize(this->getSizeX2D() - (borderLeft() + borderRight()) , this->getSizeY2D() - (borderTop() + borderBottom()));*/
  }


  void GLGuiCheckButton::releasing(const Vector2D& pos)
  {
    GLGuiButton::releasing(pos);
    this->toggleActiveState();
  }



  /**
   * @brief draws the GLGuiPushButton
   */
  void GLGuiCheckButton::draw() const
  {
    this->beginDraw();
    GLGuiButton::draw();

//     this->frontMaterial().select();
//     this->drawRect(this->frontRect());
    if (this->bActive)
    {
      glColor3fv( &this->foregroundColor()[0]);
      this->drawRect(this->_checkBox);


      // DRAW a cross :)
      Vector2D center = this->_checkBox.center();
      glColor4f(1,1,1, 1.0);
      glLineWidth(3.0);

      glBegin(GL_LINE_LOOP);
      glVertex2d(_checkBox.left(), _checkBox.top());
      glVertex2d(center.x, center.y);

      glVertex2d(_checkBox.right(), _checkBox.top());
      glVertex2d(center.x, center.y);

      glVertex2d(_checkBox.right(), _checkBox.bottom());
      glVertex2d(center.x, center.y);

      glVertex2d(_checkBox.left(), _checkBox.bottom());
      glVertex2d(center.x, center.y);
      glEnd();
    }
    else
    {
      glColor3fv( &this->foregroundColor()[0]);
      this->drawRect(this->_checkBox);
    }

    this->endDraw();
  }
}
