

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "util/loading/factory.h"
#include "util/loading/load_param.h"

#include "interactive_model.h"
#include "md2/md2Model.h"

#include "sound_buffer.h"

#include "loading/resource_manager.h"

#include "generic_npc.h"

using namespace std;



CREATE_FACTORY(GenericNPC, CL_GENERIC_NPC);



/**
 * constructor
 */
GenericNPC::GenericNPC(const TiXmlElement* root)
  : NPC(root)
{
  this->init();

  if (root != NULL)
    this->loadParams(root);
}


/**
 * deconstructor
 */
GenericNPC::~GenericNPC ()
{}


/**
 * initializing the npc enity
 */
void GenericNPC::init()
{
  this->setClassID(CL_GENERIC_NPC, "GenericNPC");
  this->toList(OM_GROUP_00);

  if (this->soundBuffer != NULL)
    ResourceManager::getInstance()->unload(this->soundBuffer);
  this->soundBuffer = (OrxSound::SoundBuffer*)ResourceManager::getInstance()->load("sound/rain.wav", WAV);
}


/**
 * loads the Settings of a MD2Creature from an XML-element.
 * @param root the XML-element to load the MD2Creature's properties from
 */
void GenericNPC::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);

  LoadParam(root, "md2animation", this, GenericNPC, setAnimation)
      .describe("sets the animation of the md2 model")
      .defaultValues(1);

}


/**
 * sets the animation of this npc
 * @param anumationIndex: the animation index
 * @param anumPlaybackMode: the playback mode
 */
void GenericNPC::setAnimation(int animationIndex, int animPlaybackMode)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->setAnimation(animationIndex, animPlaybackMode);
}


/**
 * sets the animation of this npc
 * @param anumationIndex: the animation index
 * @param anumPlaybackMode: the playback mode
 */
bool GenericNPC::playAnimation(int animationIndex, int animPlaybackMode)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->setAnimation(animationIndex, animPlaybackMode);

  return true;
}


/**
 * play a sound
 * @param filename: name of the file
 */
bool GenericNPC::playSound(std::string filename)
{
  return true;
}


/**
 * walt to
 * @param coordinate: coordinate to go to
 */
bool GenericNPC::walkTo(const Vector& coordinate, float time)
{

  return true;
}


/**
 * walt to
 * @param coordinate: coordinate to go to
 */
bool GenericNPC::walkTo(float x, float y, float z, float time)
{

  return true;
}


/**
 * tick this world entity
 * @param time: time in seconds expirded since the last tick
 */
void GenericNPC::tick (float time)
{
  if( likely(this->getModel(0) != NULL))
    ((InteractiveModel*)this->getModel(0))->tick(time);
}



void GenericNPC::destroy()
{
  int randi = (int)(5.0f * (float)rand()/(float)RAND_MAX);

  if( randi == 1)
    this->setAnimation(DEATH_FALLBACK, MD2_ANIM_ONCE);
  else if( randi == 2)
    this->setAnimation(DEATH_FALLFORWARD, MD2_ANIM_ONCE);
  else if( randi == 3)
    this->setAnimation(DEATH_FALLBACKSLOW, MD2_ANIM_ONCE);
  else if( randi == 4)
    this->setAnimation(CROUCH_DEATH, MD2_ANIM_ONCE);
  else
    this->setAnimation(DEATH_FALLBACK, MD2_ANIM_ONCE);
}

