/*!
 * @file glgui_defs.h
 * Definitions for the GLGui.
 */

#ifndef _GLGUI_DEFS_H
#define _GLGUI_DEFS_H

#include <string>

/// TODO MOVE TO ORXGUI_TYPES
namespace OrxGui
{
  //! if the Element should be visible by default.
#define GLGUI_WIDGET_DEFAULT_VISIBLE       false


  //! An enumeration for the Orientation of an Element.
  typedef enum {
    Horizontal,       //!< Horizontal Orientation.
    Vertical          //!< Vertical Orientation.
  } Orientation;

  //! Names of Orientations
  const std::string OrientationString[] = {
    "Horizontal",
    "Vertical"
  };

  //! An enumerator that defines the different states Widgets may be in.
  typedef enum {
    Normal,           //!< Normal state of the GUI's Widgets.
    Focused,           //!< If the widget is Active.
    Selected,         //!< If the Widget is Selected.
    Insensitive       //!< If the Widget is insensitive.
  } State;
  //! The count of States a GUI-Element can be in.
#define GLGUI_STATE_COUNT   4
#define GLGUI_DEFAULT_STYLE OrxGui::Normal

//! names of the States.
  const std::string StateString[] =
    {
      "Normal",
      "Focused",
      "Selected",
      "Insensitive"
    };

    //! Where a Certain feature will be positioned at.
    typedef enum {
      FeatureLeft,          //!< On the Left side.
      FeatureRight,         //!< On the Right side.
      FeatureTop,           //!< On Top of the rest of the Widget.
      FeatureBottom,        //!< At the Bottom of the rest of the Widget.
    } FeaturePosition;

    //! Names of Feature-Positions
    const std::string FeaturePositionString[] =
    {
      "Left",
      "Right",
      "Top",
      "Bottom"
    };



};


#endif /* _GLGUI_DEFS_H */
