/*!
 * @file md3_animation.h
 *
 * Code heavely inspired by: JAVA MD3 Model Viewer - A Java based Quake 3 model viewer
 * Copyright (C) 1999 Erwin 'KLR8' Vervaet
 */

#ifndef _MD3_ANIMATION_CFG_H
#define _MD3_ANIMATION_CFG_H

#include "vector.h"

#include <string>
#include <map>


namespace md3
{
  class MD3Animation;


  /**
   * a class with metadata describing an MD3 model animation
   */
  class MD3AnimationCfg
  {

    public:
      MD3AnimationCfg();
      MD3AnimationCfg(std::string filename);
      virtual ~MD3AnimationCfg();


      std::string toString() { return std::string("Name: " + this->filename); }


    public:
      std::string             filename;            //!< filename of the config file

      char                    sex;                 //!< sex of animated model: 'm' for male, 'f' for female
      Vector                  headOffset;          //!< head offset. this is the offset of the head model in the HUD x,y,z
      std::string             footsteps;           //!< type of the footstep sounds associated with anumations (e.g. "mech", "default")

      std::map<std::string, MD3Animation*>     animations;          //!< mapping of animation names to MD3Animation objects.
  };
}

#endif /* _MD3_ANIMATION_CFG_H */
