/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_IMPORTER

#include "md3_animation_cfg.h"



namespace md3
{

  /**
   * create an empty MD3AnimationCfg object
   */
  MD3AnimationCfg::MD3AnimationCfg()
  {
  }


  /**
   * create a new MD3 Anumation object and initialize it with the data on the given line
   * @param line: the line to read from
   */
  MD3AnimationCfg::MD3AnimationCfg(std::string line)
  {
  }


  /**
   * deconstructor
   */
  MD3AnimationCfg::~MD3AnimationCfg()
  {}



  /**
  * <p>Look up the animation data for the animation with the specified name.
  *
  * @param name Name of the animation.
  * @return The animation data associated with the name or null if no data was found.
  */
  MD3Animation* getAnimation(std::string name)
  {
//     return (MD3Animation)animations.get(name);
  }

}

#if 0
      /**
         * <p>Create an empty animation data resource. Use this when creating and
         * managing your own animations.
      */
        protected AnimationCfg() {
                animations=new TreeMap();
}

        /**
         * <p>Constructor that loads an <i>animation.cfg</i> file into the internal
         * data stuctures. The read information can later be consulted using the
         * animationNames() and getAnimation() methods.
         *
         * @param file The file to open.
        */
        protected AnimationCfg(String file) throws IOException {
                this();
                InputStream fin=new FileInputStream(file);
                CFGIO.loadAnimationCfg(this, fin);
                fin.close();
}

        /**
         * <p>Constructor that loads <i>animation.cfg</i> data coming from the specified
         * input stream into the internal data stuctures. The read information can later
         * be consulted using the animationNames() and getAnimation() methods.
         *
         * @param in The stream to read data from.
        */
        protected AnimationCfg(InputStream in) throws IOException {
                this();
                CFGIO.loadAnimationCfg(this, in);
}

        /**
         * <p>Return an Iterator listing the names of all known animations.
        */
        public Iterator animationNames() {
                return animations.keySet().iterator();
}

        /**
         * <p>Look up the animation data for the animation with the specified name.
         *
         * @param name Name of the animation.
         * @return The animation data associated with the name or null if no data was found.
        */
        public MD3Animation getAnimation(String name) {
                return (MD3Animation)animations.get(name);
}

        /**
         * <p>Add the specified animation to the list of known animations.
        */
        public void putAnimation(MD3Animation anim) {
                animations.put(anim.name, anim);
}
#endif

