/*!
 * @file glgui_style.h
 * @brief Definition of the OpenGL-GUI Style of a Class.
*/

#ifndef _GLGUI_STYLE_H
#define _GLGUI_STYLE_H

#include "glgui_defs.h"

#include "font.h"
#include "texture.h"
#include "color.h"

class TiXmlElement;

namespace OrxGui
{
  //! A class for Defining Styles to the opengl-gui.
  class GLGuiStyle
  {
  public:
    GLGuiStyle(const TiXmlElement* root = NULL);
    virtual ~GLGuiStyle();


    /// Retrieve
    inline float borderLeft(OrxGui::State state = GLGUI_DEFAULT_STYLE) const { return _style[state]._borderLeft; }
    inline float borderRight(OrxGui::State state = GLGUI_DEFAULT_STYLE) const { return _style[state]._borderRight; }
    inline float borderTop(OrxGui::State state = GLGUI_DEFAULT_STYLE) const { return _style[state]._borderTop; }
    inline float borderBottom(OrxGui::State state = GLGUI_DEFAULT_STYLE) const { return _style[state]._borderBottom; }
    inline float textSize(OrxGui::State state = GLGUI_DEFAULT_STYLE) const { return _style[state]._textSize; }
    inline const Color& backgroundColor(OrxGui::State state= GLGUI_DEFAULT_STYLE) const { return _style[state]._backgroundColor; }
    inline const Texture& backgrorundTexture(OrxGui::State state= GLGUI_DEFAULT_STYLE) const { return _style[state]._backgroundTexture; }
    inline const Color& foregroundColor(OrxGui::State state= GLGUI_DEFAULT_STYLE) const { return _style[state]._foregroundColor; }

    inline FeaturePosition featurePosition() const { return _featurePosition; }
    inline const Font* const font() const { return _font; }
    inline bool animated() const { return _animated; }
    inline bool animatedStateChanges() const { return _animatedStateChanges; }



    /// SETUP
    void reset();
    void loadParams(const TiXmlElement* root);

    void setBorderLeft(float value);
    void setBorderLeft(float value, OrxGui::State state);
    void setBorderLeftS(float value, const std::string& state);

    void setBorderRight(float value);
    void setBorderRight(float value, OrxGui::State state);
    void setBorderRightS(float value, const std::string& state);

    void setBorderTop(float value);
    void setBorderTop(float value, OrxGui::State state);
    void setBorderTopS(float value, const std::string& state);

    void setBorderBottom(float value);
    void setBorderBottom(float value, OrxGui::State state);
    void setBorderBottomS(float value, const std::string& state);

    void setTextSize(float value);
    void setTextSize(float value, OrxGui::State state);
    void setTextSizeS(float value, const std::string& state);

    void setBackgroundColor(const Color& color);
    void setBackgroundColor(const Color& color, OrxGui::State state);
    void setBackgroundColorS(float r, float g, float b, float a, const std::string& state);

    void setBackgroundTexture(const Texture& texture);
    void setBackgroundTexture(const Texture& texture, OrxGui::State state);
    void setBackgroundTexture(const std::string& textureName, const std::string& state);

    void setForegroundColor(const Color& color);
    void setForegroundColor(const Color& color, OrxGui::State state);
    void setForegroundColorS(float r, float g, float b, float a, const std::string& state);


    void setFeaturePosition(FeaturePosition featurePosition);
    void setFeaturePosition(const std::string& featurePosition);

    void setFont(Font* font);
    void setFont(const std::string& fontName);

    void setAnimated(bool animated);
    void setAnimatedStateChanges(bool animated);

  private:
    typedef struct
    {
      float             _borderLeft;           //!< The Distance to the left Border of the widget, before any internal Element starts.
      float             _borderRight;          //!< The Distance to the right Border of the widget, before any internal Element starts.
      float             _borderTop;            //!< The Distance to the top Border of the widget, before any internal Element starts
      float             _borderBottom;         //!< The Distance to the bottom Border of the widget, before any internal Element starts

      float             _textSize;             //!< The TextSize of the Widget.

      Color             _backgroundColor;      //!< The BackgroundColor of the Widget.
      Texture           _backgroundTexture;    //!< The BackgroundTexture of the Widget.

      Color             _foregroundColor;      //!< The foregroundColor of the Widget.
    }
    StatedStyle;


    StatedStyle         _style[GLGUI_STATE_COUNT];

    FeaturePosition     _featurePosition;      //!< The Position a Feature will be layed at (checkbox(box), slider(text),...)
    Font*               _font;                 //!< The Font used in the current Widget.


    bool                _animated;             //!< If the Widget is animated (Texture might be an AnimatedTexture.)
    bool                _animatedStateChanges; //!< If the Transitions between States are Animated automatically.
  };
}
#endif /* _GLGUI_STYLE_H */
