/**
* @file lightening_effect.h
*/

#ifndef _LIGHTENING_EFFECT
#define _LIGHTENING_EFFECT

#include "vector.h"
#include "vector2D.h"

#include "weather_effect.h"

#include "sound_buffer.h"
#include "sound_source.h"

class Billboard;
class Light;

class LighteningEffect : public WeatherEffect
{
	public:
		LighteningEffect(const TiXmlElement* root = NULL);
		virtual ~LighteningEffect();

		virtual void loadParams(const TiXmlElement* root);

		virtual void init();

		virtual void activate();
		virtual void deactivate();

		inline  void activateLightening() { this->activate(); }
		inline  void deactivateLightening() { this->deactivate(); }

		virtual void draw() const;
		virtual void tick(float dt);
		
		void coord(float x, float y, float z);
		void setFlashSize(float width, float height, float seedWidth, float seedHeight);
		
		inline void setLighteningOption(const std::string& option) {
			if (option == "activate") this->lighteningActivate = true;
			if (option == "movelightening") this->lighteningMove = true;
		}

		inline void setFlashFrequency(float mainFrequency, float seedTime) {
			this->mainFrequency = mainFrequency;
			this->flashFrequency = mainFrequency;
			this->seedTime = seedTime;
		}
		
		inline void setFlashConstTime(float flashConstTime) { this->flashConstTime = flashConstTime; }

		inline void setFlashRisingTime(float flashRisingTime) {
			if(flashRisingTime > this->flashConstTime)
				this->flashRisingTime = this->flashConstTime/2;
			else
				this->flashRisingTime = flashRisingTime;
		}
		
		inline void setFlashSeed(float seedX, float seedZ) {
			this->seedX = seedX;
			this->seedZ = seedZ;
		}
		

	private:
		Billboard* billboard[4];
		bool lighteningActivate;
		bool lighteningMove;
		
		float flashFrequency;
		float mainFrequency;
		float flashConstTime;
		float flashRisingTime;
		
		float time;
		
		bool  bNewCoordinate;
		float width;
		float height;
		float seedWidth;
		float seedHeight;
		
		float seedX;
		float seedZ;
		float seedTime;
		
		float mainPosX;
		float mainPosY;
		float mainPosZ;
		
		Vector cameraCoor;
		
		Light* flashLight;
		
		//OrxSound::SoundSource    soundSource;
		//OrxSound::SoundBuffer*   thunderBuffer;

};

#endif  /* _LIGHTENING_EFFECT */
