/**
* @file fog_effect.h
*/

#ifndef _FOG_EFFECT
#define _FOG_EFFECT


#include "weather_effect.h"
#include "glincl.h"
#include "vector.h"

class FogEffect : public WeatherEffect {
public:
    FogEffect(const TiXmlElement* root = NULL);
    virtual ~FogEffect();

    virtual void loadParams(const TiXmlElement* root);

    virtual void init();

    virtual void activate();
    virtual void deactivate();

    void activateFog() {
        this->activate();
    }
    void deactivateFog() {
        this->deactivate();
    }

    virtual void draw() const;
    virtual void tick(float dt);

    inline void setFogMode(const std::string& mode) {
        this->fogMode = this->stringToFogMode(mode);
    }
    inline void setFogDensity(float density) {
        this->fogDensity = density;
    }
    inline void setFogRange(float start, float end) {
        this->fogStart = start;
        this->fogEnd = end;
    }
    inline void setFogColor(float r, float g, float b) {
        this->colorVector = Vector(r, g, b);
    }
    inline void setFogFadeIn(float fadein) {
        this->fogFadeInDuration = fadein;
    }
    inline void setFogFadeOut(float fadeout) {
        this->fogFadeOutDuration = fadeout;
    }

    inline void setFogOption(const std::string& option) {
        if (option == "activate")
            this->fogActivate = true;
    }

    void fadeInFog();
    void fadeOutFog();


private:
    GLint stringToFogMode(const std::string& mode);

    bool          fogActivate;

    bool          fogFadeInActivate;
    bool          fogFadeOutActivate;

    GLfloat       fogFadeInDuration;
    GLfloat       fogFadeOutDuration;

    float         localTimer;

    GLint         fogMode;
    GLfloat       fogDensity;
    GLfloat       fogFadeDensity;

    GLfloat       fogStart;
    GLfloat       fogEnd;
    Vector        colorVector;
};


#endif  /* _FOG_EFFECT */
