/**
* @file cloud_effect.h
*/

#ifndef _CLOUD_EFFECT
#define _CLOUD_EFFECT

#include "weather_effect.h"

#include "sound_buffer.h"
#include "sound_source.h"

#include "world_entity.h"
#include "material.h"
#include "shader.h"

class CloudEffect : public WeatherEffect {
public:
    CloudEffect(const TiXmlElement* root = NULL);
    virtual ~CloudEffect();

    virtual void loadParams(const TiXmlElement* root);

    virtual void init();

    virtual void activate();
    virtual void deactivate();

    inline void activateCloud() {
        this->activate();
    }
    inline void deactivateCloud() {
        this->deactivate();
    }

    virtual void draw() const;
    virtual void tick(float dt);

    /*inline void setCloudOption(const std::string& option) {
        if (option == "activate")
    this->cloudActivate = true;
}*/


private:
    //void initialize(char* fileName);

    //bool        cloudActivate;

    Material                 cloudMaterial;
    Shader*                 shader;
};

#endif  /* _CLOUD_EFFECT */
