/*
	orxonox - the future of 3D-vertical-scrollers

	Copyright (C) 2004 orx

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.

### File Specific:
	main-programmer: hdavid, amaechler

	INSPIRED BY http://www.codesampler.com/usersrc/usersrc_6.htm#oglu_sky_dome_shader
*/

#include "cloud_effect.h"

#include "util/loading/load_param.h"
#include "util/loading/factory.h"
#include "util/loading/resource_manager.h"

#include "material.h"
#include <math.h>
#include "state.h"
#include "p_node.h"
#include "shader.h"
#include "shell_command.h"

#include "parser/tinyxml/tinyxml.h"


using namespace std;

SHELL_COMMAND(activate, CloudEffect, activateCloud);
SHELL_COMMAND(deactivate, CloudEffect, deactivateCloud);

CREATE_FACTORY(CloudEffect, CL_CLOUD_EFFECT);

CloudEffect::CloudEffect(const TiXmlElement* root)
{
	this->setClassID(CL_CLOUD_EFFECT, "CloudEffect");
//  this->toList(OM_ENVIRON);

	this->init();

	if (root != NULL)
		this->loadParams(root);

	//if(cloudActivate)
		this->activate();
}

CloudEffect::~CloudEffect()
{
	this->deactivate();
}


void CloudEffect::init()
{
	PRINTF(0)("Initializing CloudEffect\n");
  
    /// initialization of the texture coords, speeds etc...
/*  this->move = 0.0f;
  this->g_WaterUV = 35.0f;
  this->kNormalMapScale = 0.25f;
  this->g_WaterFlow = 0.0015f;*/
  
  cloudMaterial.setDiffuseMap("pictures/sky/cloud1.jpg", GL_TEXTURE_2D, 0);

  shader = new Shader(ResourceManager::getInstance()->getDataDir() + "/shaders/cloud.vert",
                      ResourceManager::getInstance()->getDataDir() + "/shaders/cloud.frag");
  
  this->shader->activateShader();

  Shader::Uniform(shader, "Noise").set(0);
  Shader::Uniform(shader, "SkyColor").set(0.0f, 0.0f, 0.8f);
  Shader::Uniform(shader, "CloudColor").set(0.8f, 0.8f, 0.8f);
  
  // Change: Have to be updated each frame!like camerpos in mapped_water.cc
  Shader::Uniform(shader, "Offset").set(0.0f, 0.0f, 0.0f);
  
  Shader::Uniform(shader, "LightPos").set(100.0f, 100.0f, 100.0f);
  Shader::Uniform(shader, "Scale").set(1.0f);
  
  this->shader->deactivateShader();
}


void CloudEffect::loadParams(const TiXmlElement* root)
{
	WeatherEffect::loadParams(root);

	// LoadParam(root, "speed", this, CloudEffect, setCloudAnimation);
	// LoadParam(root, "texture", this, CloudEffect, setCloudTexture);
  /*
	LOAD_PARAM_START_CYCLE(root, element);
	{
		LoadParam_CYCLE(element, "option", this, CloudEffect, setCloudOption);
	}
  LOAD_PARAM_END_CYCLE(element);*/
}


void CloudEffect::activate()
{
	PRINTF(0)( "Activating\n");

//	this->cloudActivate = true;
}

void CloudEffect::deactivate()
{
	PRINTF(0)("Deactivating CloudEffect\n");

//	this->cloudActivate = false;
}

void CloudEffect::draw() const
{
	//if (!this->cloudActivate)
	//	return;

  //glMatrixMode(GL_MODELVIEW);
  //glColor4f(1,1,1,1);
  glPushMatrix();
  //glTranslatef(0,this->waterHeight,0);

  cloudMaterial.unselect();
  cloudMaterial.select();

  this->shader->activateShader();


  glBegin(GL_QUADS);
  
  glTexCoord2f(1.0f, 1.0f); glVertex3f(0.0f, 0.0f,  0.0f);
  glTexCoord2f(0.0f, 1.0f); glVertex3f( 0.0f, 0.0f,  100.0f);
  glTexCoord2f(0.0f, 0.0f); glVertex3f( 100.0f, 0.0f,  100.0f);
  glTexCoord2f(1.0f, 0.0f); glVertex3f(100.0f, 0.0f,  0.0f);
  
  glEnd();

  this->shader->deactivateShader();

  cloudMaterial.unselect();

  glPopMatrix();

}

void CloudEffect::tick (float dt)
{
	//if (!this->cloudActivate)
	//	return;
}

