#ifndef _SCRIPT_TRIGGER_H
#define _SCRIPT_TRIGGER_H

#include <string>

#include "world_entity.h"
#include "loading/load_param.h"
#include "vector.h"
#include "script_manager.h"
#include "script.h"

class ScriptTrigger : public WorldEntity
{
  public:
    ScriptTrigger(const TiXmlElement* root = NULL);
    ~ScriptTrigger();

    ///LOADING
    virtual void loadParams(const TiXmlElement* root);


    /// DO WORK
    virtual void tick(float timestep);
    virtual void executeAction(float timestep);
    void testScriptingFramework();

    /// SET MEMBER
    void setTarget(const std::string& targetName);
    void setTarget(WorldEntity* target) { if(target!=NULL) this->target=target; }
    void setTriggerParent(const std::string& name);
    void setCallOnce(const bool call) { this->callOnce = call; }
    void setTriggerLasts(const bool lasts) { this->triggerLasts = lasts; }
    void setInvert(const bool inv) { this->invert = invert; }
    void setRadius(const float radius) { if(radius>0) this->radius = radius; }
    void setDelay(const float time){if(delay>0) this->delay = delay; }
    void setScript(const std::string& file);
    void setFunction(const std::string& function){ this->functionName = function;}
    void setDebugDraw(const bool draw) { this->doDebugDraw = draw; }

    ///DRAWING
    void draw()const{if(doDebugDraw)this->debugDraw();};

  private:

    WorldEntity* target;
    bool         callOnce;
    bool         triggerLasts;
    bool         invert;
    float        radius;
    float        delay;
    Script*      script;
    std::string  functionName;
    bool         doDebugDraw;

    //for internal use
    bool         scriptCalled;
    bool         scriptIsOk;
    bool         actionFinished;
    int          returnCount;

};

#endif
