/*!
 * @file hud.h
 * @brief Definition of the ingame HUD.
*/

#ifndef _HUD_H
#define _HUD_H

#include "element_2d.h"
// FORWARD DECLARATION
class TiXmlElement;
class WeaponManager;
namespace OrxGui { class GLGuiWidget; }

//! A class that renders a HUD.
class Hud : public Element2D
{

public:
  Hud();
  virtual ~Hud();


  virtual void loadParams(const TiXmlElement* root);

  void setBackGround();
  void setEnergyWidget(OrxGui::GLGuiWidget* widget);
  void setShiledWidget(OrxGui::GLGuiWidget* widget);
  void setArmorWidget(OrxGui::GLGuiWidget* widget);
  void setWeaponManager(WeaponManager* weaponMan);

  void addWeaponWidget(OrxGui::GLGuiWidget* widget);
  void removeWeaponWidget(OrxGui::GLGuiWidget* widget);

  void updateWeaponManager();

  void tick(float dt);
  void draw() const;

  private:
    void updateResolution();

private:
  unsigned int             resX;
  unsigned int             resY;

  OrxGui::GLGuiWidget*     energyWidget;
  OrxGui::GLGuiWidget*     shieldWidget;
  OrxGui::GLGuiWidget*     armorWidget;

  WeaponManager*           weaponManager;

  std::list<OrxGui::GLGuiWidget*> weaponsWidgets; //!< WeaponWidgets will be displayed one after another
};

#endif /* _HUD_H */
