/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "glgui_style.h"

#include "loading/load_param.h"

namespace OrxGui
{


  /**
   * @brief standard constructor
  */
  GLGuiStyle::GLGuiStyle (const TiXmlElement* root)
  {
    if (root != NULL)
      this->loadParams(root);

    this->
  }


  /**
   * @brief standard deconstructor
   */
  GLGuiStyle::~GLGuiStyle ()
  {
    // delete what has to be deleted here
  }

  void GLGuiStyle::loadParams(const TiXmlElement* root)
  {
  }

  void GLGuiStyle::setBorderLeft(float value)
  {
    for (unsigned int i = 0; i < GLGUI_STATE_COUNT; ++i)
      setBorderLeft(value, (OrxGui::State)i);
  }

  void GLGuiStyle::setBorderLeft(float value, OrxGui::State state)
{}

  void GLGuiStyle::setBorderLeftS(float value, const std::string& state)
  {}


  void GLGuiStyle::setBorderRight(float value)
  {
    for (unsigned int i = 0; i < GLGUI_STATE_COUNT; ++i)
      setBorderRight(value, (OrxGui::State)i);
  }

  void GLGuiStyle::setBorderRight(float value, OrxGui::State state)
{}

  void GLGuiStyle::setBorderRightS(float value, const std::string& state)
  {}


  void GLGuiStyle::setBorderTop(float value)
  {
    for (unsigned int i = 0; i < GLGUI_STATE_COUNT; ++i)
      setBorderTop(value, (OrxGui::State)i);
  }

  void GLGuiStyle::setBorderTop(float value, OrxGui::State state)
{}

  void GLGuiStyle::setBorderTopS(float value, const std::string& state)
  {}


  void GLGuiStyle::setBorderBottom(float value)
  {
    for (unsigned int i = 0; i < GLGUI_STATE_COUNT; ++i)
      setBorderBottom(value, (OrxGui::State)i);
  }

  void GLGuiStyle::setBorderBottom(float value, OrxGui::State state)
{}

  void GLGuiStyle::setBorderBottomS(float value, const std::string& state)
  {}


  void GLGuiStyle::setTextSize(float value)
  {
    for (unsigned int i = 0; i < GLGUI_STATE_COUNT; ++i)
      setTextSize(value, (OrxGui::State)i);
  }

  void GLGuiStyle::setTextSize(float value, OrxGui::State state)
{}

  void GLGuiStyle::setTextSizeS(float value, const std::string& state)
  {}


  void GLGuiStyle::setBackgroundColor(const Color& color)
  {
    for (unsigned int i = 0; i < GLGUI_STATE_COUNT; ++i)
      setBackgroundColor(color, (OrxGui::State)i);
  }

  void GLGuiStyle::setBackgroundColor(const Color& color, OrxGui::State state)
{}

  void GLGuiStyle::setBackgroundColorS(float r, float g, float b, float a, const std::string& state)
  {}


  void GLGuiStyle::setBackgroundTexture(const Texture& texture)
  {
    for (unsigned int i = 0; i < GLGUI_STATE_COUNT; ++i)
      setBackgroundTexture(texture, (OrxGui::State)i);
  }

  void GLGuiStyle::setBackgroundTexture(const Texture& texture, OrxGui::State state)
{}

  void GLGuiStyle::setBackgroundTexture(const std::string& textureName, const std::string& state)
  {}


  void GLGuiStyle::setForegroundColor(const Color& color)
  {
    for (unsigned int i = 0; i < GLGUI_STATE_COUNT; ++i)
      setForegroundColor(color, (OrxGui::State)i);
  }

  void GLGuiStyle::setForegroundColor(const Color& color, OrxGui::State state)
  {}

  void GLGuiStyle::setForegroundColorS(float r, float g, float b, float a, const std::string& state)
  {}



  void GLGuiStyle::setFeaturePosition(FeaturePosition featurePosition)
  {
    this->_featurePosition = featurePosition;
  }

  void GLGuiStyle::setFeaturePosition(const std::string& featurePosition)
  {

  }


  void GLGuiStyle::setFont(Font* font)
  {
    this->_font = font;
  }

  void GLGuiStyle::setFont(const std::string& fontName)
  {
    //this->font = new Font(fontName);
  }


  void GLGuiStyle::setAnimated(bool animated)
  {
    this->_animated = animated;
  }

  void GLGuiStyle::animatedStateChanges(bool animated)
  {
    this->_animatedStateChanges = animated;
  }

}
