/*!
 * @file glgui_inputline.h
 * The gl_INPUTLINE widget of th openglGUI
 *
 */

#ifndef _GLGUI_INPUTLINE_H
#define _GLGUI_INPUTLINE_H

#include "glgui_widget.h"
#include "text.h"
#include "event.h"

// FORWARD DECLARATION
namespace OrxGui
{

  //! This is InputLine part of the openglGUI class
  /**
   * The InputLine is a Widget, that displays a Line, that can be manipulated through
   * Writing Text on it.
   *
   * Whenever the Text is changed the textChanged signal is emitted.
   */
  class GLGuiInputLine : public OrxGui::GLGuiWidget
  {

  public:
    GLGuiInputLine();
    virtual ~GLGuiInputLine();


    /** @returns the text of the inputLine */
    const std::string& _getText() const { return this->_text.getText(); };

    void setText(const std::string& text);
    void append(const std::string& appendText);
    void appendCharacter(char character);
    void removeCharacters(unsigned int chars);

    virtual void removedFocus();

    virtual void tick(float dt);
    virtual void draw() const;

    virtual bool processEvent(const Event& event);

    DeclareSignal1(textChanged, const std::string&);

  protected:
    virtual void updateFrontColor();
    virtual void hiding();
    virtual void showing();
    virtual void resize();


  private:
    void init();
    void changedText();

  private:
    Text                    _text;            //!< The Text to display inside of the InputLine.

    Uint16                  pressedKey;       //!< the pressed key that will be repeated.
    Uint16                  pressedKeyName;   //!< The Name of the Key, that was pressed.

    float                   delayNext;        //!< How much time must pass before next output.

    static float            repeatDelay;      //!< Repead Delay.
    static float            repeatRate;       //!< Repeat Rate.
  };
}

#endif /* _GLGUI_INPUTLINE_H */
