/*!
 * @file glgui_image.h
 * The gl_Image widget of th openglGUI
 *
 */

#ifndef _GLGUI_IMAGE_H
#define _GLGUI_IMAGE_H

#include "glgui_widget.h"

// FORWARD DECLARATION
struct SDL_Surface;
namespace OrxGui
{

  //! This is Image part of the openglGUI class
  /**
   *
   */
  class GLGuiImage : public GLGuiWidget
  {

  public:
    GLGuiImage();
    virtual ~GLGuiImage();

    void loadImageFromTexture(const Texture& texture);

    void loadImageFromFile(const std::string& fileName);
    void loadImageFromSDLSurface(SDL_Surface* surface);
    void loadImageFromDisplayList(GLuint texture);

    virtual void draw() const;

    DeclareSignal0(imageChanged);

  protected:
    virtual void updateFrontColor();
    virtual void resize();


  private:
    void init();

  private:
    Rect2D        _imagePlane;
    Material      _imageMaterial;
  };
}
#endif /* _GLGUI_IMAGE_H */
