/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GUI

#include "glgui_pushbutton.h"

#include "text.h"
#include "material.h"

namespace OrxGui
{

  /**
   * @brief standard constructor
   */
  GLGuiPushButton::GLGuiPushButton (const std::string& label)
  : GLGuiButton(label)
  {
    this->init();

    this->resize();
  }


  /**
   * @brief standard deconstructor
  */
  GLGuiPushButton::~GLGuiPushButton()
  {
  }

  void GLGuiPushButton::resize()
  {
    this->labelText().setRelCoor2D(borderLeft(), borderTop());
    this->setSize2D(this->labelText().getSizeX2D() + borderLeft() + borderRight(), this->labelText().getSizeY2D() + borderTop() + borderBottom() );

    GLGuiWidget::resize();
/*    this->frontRect().setTopLeft(borderLeft(), borderTop());
    this->frontRect().setSize(this->getSizeX2D() - (borderLeft() + borderRight()), this->getSizeY2D() - (borderTop() + borderBottom()));*/
  }

  /**
   * initializes the GUI-element
   */
  void GLGuiPushButton::init()
  {
    this->setClassID(CL_GLGUI_PUSHBUTTON, "GLGuiPushButton");
  }

  void GLGuiPushButton::receivedFocus()
  {
    printf("%s received focus\n", this->label().c_str());
    GLGuiWidget::receivedFocus();
  }

  void GLGuiPushButton::removedFocus()
  {
    printf("%s removed focus\n", this->label().c_str());
    GLGuiWidget::removedFocus();

  }

  void GLGuiPushButton::clicking(const Vector2D& pos)
  {
    printf("%s clicked\n", this->label().c_str());
    GLGuiButton::clicking(pos);
  }


  void GLGuiPushButton::releasing(const Vector2D& pos)
  {
    printf("%s released\n", this->label().c_str());
    GLGuiButton::releasing(pos);
  }



  /**
   * @brief draws the GLGuiPushButton
   */
  void GLGuiPushButton::draw() const
  {
    this->beginDraw();
    GLGuiButton::draw();

    this->endDraw();
  }

  /**
   * updates the GLGuiPushButton
   */
  void GLGuiPushButton::update()
  {

  }
}
