/*!
 * @file md3_model.h
 *
 * Code heavely inspired by: JAVA MD3 Model Viewer - A Java based Quake 3 model viewer
 * Copyright (C) 1999 Erwin 'KLR8' Vervaet
 */

#ifndef _MD3_MODEL_H
#define _MD3_MODEL_H

#include <string>
#include "interactive_model.h"


namespace md3
{


class MD3Data;

class MD3Model : public InteractiveModel
{

  public:
    MD3Model(std::string filename, float scaling);
    ~MD3Model();

    virtual void tick(float dt) {}
    virtual void setAnimation(int animNum, int playbackMode = 0) {}

  private:
    MD3Data*            md3Data;           //!< reference to the md3 model data
};

}

#endif /* _MD3_MODEL_H */
