/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/

/*!
 * @file interactive_model.h
 *  Definition of an abstract interactive model.
 *   it offers a skeletton for choosing animations, ticking the model a.s.o
 */

#ifndef _INTERACTIVE_MODEL_H
#define _INTERACTIVE_MODEL_H

#include "model.h"
#include "vector.h"



class InteractiveModel : public Model
{
  public:
    InteractiveModel();
    ~InteractiveModel();

    virtual void tick(float) = 0;

    virtual void setAnimation(int animNum, int playbackMode = 0) = 0;
};


#endif /* _INTERACTIVE_MODEL_H */
