
/*!
 * @file helicopter.h
 * Implements the Control of a Helicopter
 */

#ifndef _HELICOPTER_H
#define _HELICOPTER_H

#include "playable.h"

#include "sound_buffer.h"
#include "sound_source.h"

#include "script_class.h"

class Helicopter : public Playable
{

  public:

    Helicopter();
    Helicopter(const std::string& fileName);
    Helicopter(const TiXmlElement* root);
    virtual ~Helicopter();

    virtual void loadParams(const TiXmlElement* root);
    virtual void setPlayDirection(const Quaternion& rot, float speed = 0.0f) {/* FIXME */};

    virtual void enter();
    virtual void leave();

    virtual void postSpawn();
    virtual void leftWorld();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);
    virtual void tick(float time);
    virtual void draw() const;

    virtual void process(const Event &event);
    
    virtual void moveUp(bool move){bAscend = move;};
    virtual void moveDown(bool move){bDescend = move;};



  private:
    void init();
    void calculateVelocity(float time);

    bool                  bUp;                //!< up button pressed.
    bool                  bDown;              //!< down button pressed.
    bool                  bLeft;              //!< left button pressed.
    bool                  bRight;             //!< right button pressed.
    bool                  bAscend;            //!< ascend button pressed.
    bool                  bDescend;           //!< descend button presses.
    bool                  bFire;              //!< fire button pressed.
    bool                  bRollL;             //!< rolling button pressed (left)
    bool                  bRollR;             //!< rolling button pressed (right)

    float                 xMouse;             //!< mouse moved in x-Direction
    float                 yMouse;             //!< mouse moved in y-Direction
    int                   yInvert;
    float                 mouseSensitivity;   //!< the mouse sensitivity
    int                   controlVelocityX;   //!< defines max velocity of Xaxis of mousecontrol
    int                   controlVelocityY;   //!< defines max velocity of Yaxis of mousecontrol

    PNode                 topRotor;           //!< the position of the toprotor
    PNode                 tailRotor;          //!< the position of the tailrotor

    PNode                 cameraNode;         //!< the position the camera is locked at (used to look up and down without turning the helicopter)

    Vector                velocity;           //!< the velocity of the player.
    Vector                velocityDir;        //!< the direction of the velocity of the spaceship
    float                 travelSpeed;        //!< the current speed of the player (to make soft movement)
    float                 acceleration;       //!< the acceleration of the player.

    float                 airViscosity;

    OrxSound::SoundSource soundSource;
    OrxSound::SoundBuffer*chopperBuffer;

};

CREATE_SCRIPTABLE_CLASS(Helicopter, CL_HELICOPTER,
                        addMethod("moveUp", ExecutorLua1<Helicopter,bool>(&Helicopter::moveUp))
                        ->addMethod("moveDown", ExecutorLua1<Helicopter,bool>(&Helicopter::moveDown))
                        );


#endif /* _HELICOPTERS_H */
