/*!
 * @file md3_mesh.h
 *
 * Code heavely inspired by: JAVA MD3 Model Viewer - A Java based Quake 3 model viewer
 * Copyright (C) 1999 Erwin 'KLR8' Vervaet
 */

#ifndef _MD3_MESH_H
#define _MD3_MESH_H


#include <string>

#include "md_model_structure.h"

#include "vector.h"


namespace md3
{


  typedef struct MD3MeshHeader {

    int     id;                             //!< individual id, must be IDP3
    char    name[68];                       //!< the name of the mesh

    int     meshFrameNum;                   //!< numbers of frames
    int     textureNum;                     //!< numbers of textures
    int     vertexNum;                      //!< numbers of verteces
    int     triangleNum;                    //!< number of triangles

    int     triangleStart;                  //!< triangle start offset
    int     textureStart;                   //!< texture start offset
    int     texVecStart;                    //!< tex vec start offset
    int     vertexStart;                    //!< vertex start offset

    int     meshSize;                       //!< total mesh size
  };


  typedef struct MD3Triangle  {
    int  vertexOffset[3];
  };


class MD3Mesh
{
  public:
    MD3Mesh();
    virtual ~MD3Mesh();


  public:
    MD3MeshHeader*     header;                  //!< the header of the mesh

    //MD3Texture*      textures;                //!< array of textures of size textureNum
    MD3Triangle*       triangles;               //!< indices into mesh frames and texture coord arrays
    float*             textureCoords;           //!< U/V textures coordinates of vertices
    Vector             meshFrames;              //!< mesh frames
};

}

#endif /* _MD3_MESH_H */
