/*!
 * @file script_class.h
 * @brief Definition of ...
*/

#ifndef _SCRIPT_METHOD_H
#define _SCRIPT_METHOD_H

#include <vector>

#include "lunar.h"
#include "executor/executor_lua.h"


class ScriptMethod
{
public:
  ScriptMethod(const std::string& methodName, const Executor& executor);
  ~ScriptMethod();

  ScriptMethod& addMethod(const std::string& methodName, const Executor& executor);


private:
  struct Method
  {
    Method(const std::string& name, const Executor& executor);
    std::string    name;
    Executor*      executor;
  };

  std::vector<Method> methods;
};

#endif /* _SCRIPT_METHOD_H */
