/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "script_method.h"

/**
 * @param standard constructor
 * @todo this constructor is not jet implemented - do it
*/
ScriptMethod::ScriptMethod(const std::string& methodName, const Executor& executor)
{
  this->addMethod(methodName, executor);
}

ScriptMethod& ScriptMethod::addMethod(const std::string& methodName, const Executor& executor)
{
  this->methods.push_back(ScriptMethod::Method(methodName, executor));

  return *this;
}

ScriptMethod::Method::Method(const std::string& name, const Executor& executor)
{
  this->name = name;
  this->executor = executor.clone();
}

/**
 * standard deconstructor
*/
ScriptMethod::~ScriptMethod()
{
  for (unsigned int i = 0; i < methods.size(); i ++)
  {
    delete methods[i].executor;
  };
}



