/*!
 * @file color.h
 * @brief Definition of color-calculations
 *
 * code borrowed from:
 * http://www.easyrgb.com/math.php
*/

#ifndef _COLOR_H
#define _COLOR_H

#include "vector.h"

//! a very abstract Class that helps transforming Colors into different Systems
class Color
{
public:
  Color(float r = 0.0f, float g = 0.0f, float b = 0.0f, float a = 0.0f) { _rgba[0] = r; _rgba[1] = g; _rgba[2] = b; _rgba[3] = a; };
  Color(const Color& c) { _rgba[0] = c.r(); _rgba[1] = c.g(); _rgba[2] = c.b(); _rgba[3] = c.a(); }

  float& operator[](unsigned int i) { return _rgba[i]; }
  const float& operator[](unsigned int i) const { return _rgba[i]; }

  float r() const { return _rgba[0]; }
  float& r() { return _rgba[0]; }
  float g() const { return _rgba[1]; }
  float& g() { return _rgba[1]; }
  float b() const { return _rgba[2]; }
  float& b() { return _rgba[2]; }
  float a() const { return _rgba[3]; }
  float& a() { return _rgba[3]; }


  /// STATIC TRANSFORMATIONS
public:
  static Vector RGBtoHSV (const Vector& RGB);
  static void RGBtoHSV (const Vector& RGB, Vector& HSV);
  static Vector HSVtoRGB (const Vector& HSV);
  static void HSVtoRGB (const Vector& HSV, Vector& RGB);

private:
  static float minrgb(float r, float g, float b);
  static float maxrgb(float r, float g, float b);

private:
  float       _rgba[4]; //!< Color Values

  /*  float       _r;     //!< Red Value.
  float       _g;     //!< Green Value.
  float       _b;     //!< Blue Value.
  float       _a;     //!< Alpha Value.*/
};

#endif /* _COLOR_H */
