/*!
  \file objModel.h
  \brief Contains the OBJ-model Class, that reads in a Model from a .obj-file
*/

#ifndef _OBJMODEL_H
#define _OBJMODEL_H

#include "static_model.h"

//! A Class, that handles the parsing of an obj-file, and inclusion as a Model.
class OBJModel : public StaticModel
{
 public:
   OBJModel(const std::string& fileName, float scaling = 1.0);
  virtual ~OBJModel();

 private:
  ///// readin /////
   bool importFile (const std::string& fileName);
   bool readFromObjFile (const std::string& fileName);
   bool readMtlLib (const std::string& matFile);

  private:
   void setIllum (Material* material, const char* illum);
   void setDiffuse (Material* material, const char* rgb);
   void setAmbient (Material* material, const char* rgb);
   void setSpecular (Material* material, const char* rgb);
   void setShininess (Material* material, const char* shini);
   void setTransparency (Material* material, const char* trans);

 private:
   std::string       objPath;     //!< The Path where the obj and mtl-file are located.
};

#endif /* _OBJ_MODEL_H */
