/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/

#include "player_stats.h"

#include "class_list.h"
#include "src/lib/util/loading/factory.h"

#include "player.h"
#include "state.h"
#include "shared_network_data.h"

#include "debug.h"


CREATE_FACTORY(PlayerStats, CL_PLAYER_STATS);

/**
 * constructor
 */
PlayerStats::PlayerStats( int userId )
{
  init();

  this->userId = userId;
}

/**
 * constructor
 */
PlayerStats::PlayerStats( const TiXmlElement* root )
{
  init();
}

void PlayerStats::init( )
{
  this->setClassID( CL_PLAYER_STATS, "PlayerStats" );

  this->userId = 0;
  this->teamId = TEAM_NOTEAM;
  this->preferedTeamId = TEAM_NOTEAM;
  this->score = 0;
  this->playableClassId = 0;
  this->modelFileName = "";

  userId_handle = registerVarId( new SynchronizeableInt( &userId, &userId, "userId" ) );
  teamId_handle = registerVarId( new SynchronizeableInt( &teamId, &teamId, "teamId" ) );
  preferedTeamId_handle = registerVarId( new SynchronizeableInt( &preferedTeamId, &preferedTeamId, "preferedUserId" ) );
  score_handle = registerVarId( new SynchronizeableInt( &score, &score, "score" ) );
  playableClassId_handle = registerVarId( new SynchronizeableInt( &playableClassId, &playableClassId, "playableClassId") );
  playableUniqueId_handle = registerVarId( new SynchronizeableInt( &playableUniqueId, &playableUniqueId, "playableUniqueId" ) );
  modelFileName_handle = registerVarId( new SynchronizeableString( &modelFileName, &modelFileName, "modelFileName" ) );

  PRINTF(0)("PlayerStats created\n");
}


/**
 * standard deconstructor
 */
PlayerStats::~PlayerStats()
{
}


 /**
 * override this function to be notified on change
 * of your registred variables.
 * @param id id's which have changed
  */
void PlayerStats::varChangeHandler( std::list< int > & id )
{
  if ( std::find( id.begin(), id.end(), playableUniqueId_handle ) != id.end() )
  {
    this->setPlayableUniqueId( this->playableUniqueId );

    PRINTF(0)("uniqueID changed %d %d %d\n", userId, getHostID(), getUniqueID());
  }
}

/**
 * get stats for user userId
 * @param userId user's id
 * @return stats assigned to user
 */
PlayerStats * PlayerStats::getStats( int userId )
{
  const std::list<BaseObject*> * list = ClassList::getList( CL_PLAYER_STATS );

  if ( !list )
  {
    return NULL;
  }

  for ( std::list<BaseObject*>::const_iterator it = list->begin(); it != list->end(); it++ )
  {
    if ( dynamic_cast<PlayerStats*>(*it)->getUserId() == userId )
    {
      return dynamic_cast<PlayerStats*>(*it);
    }
  }

  return NULL;
}

/**
 * set playable class id and set playable
 */
void PlayerStats::setPlayableUniqueId( int uniqueId )
{
  const std::list<BaseObject*> * list = ClassList::getList( CL_PLAYABLE );

  if ( !list )
  {
    this->playableUniqueId = uniqueId;
    return;
  }

  this->playable = NULL;
  for ( std::list<BaseObject*>::const_iterator it = list->begin(); it != list->end(); it++ )
  {
    if ( dynamic_cast<Playable*>(*it)->getUniqueID() == uniqueId )
    {
      this->playable = dynamic_cast<Playable*>(*it);
      //TODO when OM_PLAYERS is ticked add line:
      //this->playable->toList( OM_PLAYERS );
      break;
    }
  }

  if ( this->playable && userId == getHostID() )
  {
    State::getPlayer()->setPlayable( this->playable );
  }

  this->playableUniqueId = uniqueId;
}

/**
 * get playable associated to player
 * @return playable associated to player
 */
Playable * PlayerStats::getPlayable()
{
  if ( playable )
    return playable;

  assert( playableUniqueId > 0 );

  setPlayableUniqueId( playableUniqueId );

  assert( playable );

  return playable;
}


