/*!
 * @file connection_monitor.h
    \brief provides information about the quality of a connection.
 */

#ifndef _CONNECTION_MONITOR_H
#define _CONNECTION_MONITOR_H

#include "base_object.h"
#include "netdefs.h"

#include <map>
#include <list>

#define N_PACKETS_FOR_PING 20
#define MSECS_TO_CALC_BWIDTH 1000
#define SECS_TO_TIMEOUT 10

class ConnectionMonitor : virtual public BaseObject
{
  public:
    ConnectionMonitor( int userId );
    virtual ~ConnectionMonitor();

    void processUnzippedOutgoingPacket( int tick, byte * data, int length, int stateId );
    void processUnzippedIncomingPacket( int tick, byte * data, int length, int stateId, int ackedState );

    void processZippedOutgoingPacket( int tick, byte * data, int length, int stateId );
    void processZippedIncomingPacket( int tick, byte * data, int length );

    void calculatePing();

    bool hasTimedOut();

    void printStatis();

  private:
    float calculateBandWidth( std::map<int,int> packetHistory, int tick );

    int userId;       //!< user's id

    std::map<int,int>   sentStateTicks;

    std::map<int,int>   incomingUnzippedPacketHistory;
    std::map<int,int>   outgoingUnzippedPacketHistory;

    std::map<int,int>   incomingZippedPacketHistory;
    std::map<int,int>   outgoingZippedPacketHistory;

    std::list<int>      ackDelay;
    int                 ping;

    float               incomingUnzippedBandWidth;
    float               outgoingUnzippedBandWidth;

    float               incomingZippedBandWidth;
    float               outgoingZippedBandWidth;

    int                 nIncomingPackets;
    int                 nOutgoingPackets;

    int                 nZIncomingPackets;
    int                 nZOutgoingPackets;

    int                 lastPacketTick;

    int                 lastPrintTick;
  };

#endif
