/**
* @file volfog_effect.h
*/

#ifndef _VOLFOG_EFFECT
#define _VOLFOG_EFFECT

#include "vector.h"

#include "weather_effect.h"
#include "glincl.h"

class VolFogEffect : public WeatherEffect
{
	public:
		VolFogEffect(const TiXmlElement* root = NULL);
		virtual ~VolFogEffect();

		virtual void loadParams(const TiXmlElement* root);

		virtual bool init();

		virtual bool activate();
		virtual bool deactivate();

		virtual void draw() const;
		virtual void tick(float dt);

	private:
		GLfloat fogColor[4];

};

#endif  /* _VOLFOG_EFFECT */
