/**
 * @file lense_flare.h
 *  lense flare effect
 */

#ifndef _LENSE_FLARE
#define _LENSE_FLARE

#include "graphics_effect.h"

#include <vector>

#include "vector2D.h"
#include "plane.h"
#include "glincl.h"


#define LF_MAX_FLARES 7


class TiXmlElement;
class Light;
class ImagePlane;

//! A class that handles LenseFlares. The LenseFlareManager operates on this.
class LenseFlare : public GraphicsEffect
{
  public:
    LenseFlare(const TiXmlElement* root = NULL);
    virtual ~LenseFlare();

    virtual void loadParams(const TiXmlElement* root);

    virtual bool init();

    virtual bool activate();
    virtual bool deactivate();

    virtual void draw() const;
    virtual void tick(float dt);

    void addFlare(const std::string& textureName);


  private:
    GLint stringToFogMode(const std::string& mode);
    void setSourceVisibility(bool visibility) ;


  private:
    bool                     bVisible;          //!< Checks visibility
    Light*                   lightSource;        //!< reference to the sun (or primary light source)
    std::vector<ImagePlane*>  flares;             //!< the flares array

    Vector2D                 flareVector;        //!< the axis to draw the flares on
    float                    distance;           //!< distance from center to source
    Vector2D                 screenCenter;       //!< the vector marking the center of the screen

    float*                   flareMatrix;
    Plane                    frustumPlane;       //!< plane that marks the view frustum
};


#endif /* _LENSE_FLARE */
