/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION_REACTION

#include "collision.h"
#include "collision_event.h"

#include "physics_interface.h"

#include "world_entity.h"
#include "cr_object_damage.h"

#include "debug.h"

using namespace std;


/**
 *  standard constructor
 */
CRObjectDamage::CRObjectDamage ()
  : CollisionReaction()
{
  this->setClassID(CL_CR_OBJECT_DAMAGE, "CRObjectDamage");

}


/**
 *  standard deconstructor
 */
CRObjectDamage::~CRObjectDamage ()
{
}


/**
 * caluculates and applys the reaction to a specific collision
 *  @param collision the collision
 */
void CRObjectDamage::reactToCollision(Collision* collision)
{
  float damage;

  PRINTF(0)("Dealing damage - Handling collision: %s vs %s\n",
            collision->getEntityA()->getClassName(),
            collision->getEntityB()->getClassName());

  // the collision damage been dealed by the entity
  if( collision->isEntityACollide()) {
    damage = collision->getEntityB()->getDamage();
    collision->getEntityA()->decreaseHealth(damage);
  }
  PRINTF(0)("Dealing damage - %f damage to %s \n", damage, collision->getEntityA()->getClassName());

  if( collision->isEntityBCollide()) {
    damage = collision->getEntityA()->getDamage();
    collision->getEntityB()->decreaseHealth(damage);
  }
  PRINTF(0)("Dealing damage - %f damage to %s \n", damage, collision->getEntityB()->getClassName());

  collision->flushCollisionEvents();
  collision->dispatched();

//   const std::vector<CollisionEvent*>* collisionEvents = &(collision->getCollisionEvents());
//   std::vector<CollisionEvent*>::const_iterator it = collisionEvents->begin();
//   for(; it != collisionEvents->end(); it++)
//   {
//     // go through the collisions and try to estimate the damage
//     mass = (*it)->getEntityA()->getMass();
//   }

}

