/*!
 * @file md3_mesh.h
 *
 * Code heavely inspired by: JAVA MD3 Model Viewer - A Java based Quake 3 model viewer
 * Copyright (C) 1999 Erwin 'KLR8' Vervaet
 */

#ifndef _MD3_TAG_H
#define _MD3_TAG_H

#include <string>

#include "vector.h"

namespace md3
{

typedef struct MD3TagData
{
  sVec3D     position;
  float      matrix[3][3];
};


class MD3Tag
{
  public:
    MD3Tag();
    virtual ~MD3Tag();


  private:
    std::string               name;                   //!< name of tag as its usualy called in the md3 file
    Vector                    position;               //!< the position of the tag reltive to the models containing that tag
    float                     matrix[3][3];           //!< 3x3 rotation matrix

    MD3TagData*               data;                   //!< data reference
};

}

#endif /* _MD3_TAG_H */
