
/*!
 * @file game_rules.h
 * Defines game rules for this game
 */

#ifndef _GAME_RULES_H
#define _GAME_RULES_H

#include "base_object.h"
#include <vector>

#include "kill.h"

class TiXmlElement;
class ObjectManager;
class Player;
class MissionGoal;
class Kill;


class GameRules : virtual public BaseObject
{

  public:
    GameRules(const TiXmlElement* root);
    virtual ~GameRules();

    virtual void loadParams(const TiXmlElement* root = NULL);
    void loadMissionGoal(const TiXmlElement* root = NULL);


    /** adding an mission goal to the game rules @param missionGoal the mission goal to add */
    inline void addMissionGoal(MissionGoal* missionGoal) { this->missionList.push_back(missionGoal); }
    /** adding a kill event to the kill list @param kill the kill object containing all infos */
    inline void registerKill(const Kill& kill) { PRINTF(0)("Received Event: Kill\n"); this->killList.push_back(kill); }

    virtual void onPlayerSpawn() {}
    virtual void onPlayerDeath() {}


    virtual void tick(float dt) = 0;
    /** draws the stuff from the game rules if there is any need to */
    void draw() {}


  protected:
    virtual void checkGameRules() {}


  protected:
    ObjectManager*              pObjectManager;         //!< reference to the current Object Manager
    Player*                     localPlayer;            //!< reference to the local player
    std::vector<MissionGoal*>   missionList;            //!< list of mission goals

    std::vector<Kill>          killList;               //!<  list of kills in the world
};


#endif /* _GAME_RULES_H */
