/*!
 * @file glgui_cursor.h
 * The gl_cursor widget of th openglGUI
 *
 */

#ifndef _GLGUI_CURSOR_H
#define _GLGUI_CURSOR_H

#include "glgui_widget.h"
#include "event_listener.h"
#include "vector2D.h"

#include "texture_sequence.h"

class TextureSequence;

namespace OrxGui
{
  // FORWARD DECLARATION

  //! This is part of the openglGUI class
  /**
   *
   */
  class GLGuiCursor : public GLGuiWidget, public EventListener
  {

  public:
    GLGuiCursor();
    virtual ~GLGuiCursor();


    bool loadTextureSequence(const std::string& imagePrefix, unsigned int from, unsigned int to);


    const Vector2D& position() const { return Element2D::getAbsCoor2D(); }

    void setMaxBorders(const Vector2D& maxBorders) { this->_maxBorders = maxBorders; };
    static void setMouseSensitivity(float mouseSensitivity);
    static float mouseSensitivity() { return GLGuiCursor::_mouseSensitivity; };


    virtual void tick(float dt);
    virtual void draw() const;
    virtual void process(const Event& event);

  private:
    void init();

  private:

    Vector2D      _maxBorders;

    Vector2D      newPos;
    Vector2D      movement;

    float         color; // so f****ing temporary... ... ....

    static float        _mouseSensitivity;
    TextureSequence     seq;
    float               frameNumber;

  };
}
#endif /* _GLGUI_CURSOR_H */
